/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebSessionStatValue;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class WebSessionStat {
    private static final Log LOG = LogFactory.getLog(WebSessionStat.class);
    private final String sessionId;
    private volatile int runningCount;
    private volatile int concurrentMax;
    static final AtomicIntegerFieldUpdater<WebSessionStat> runningCountUpdater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "runningCount");
    static final AtomicIntegerFieldUpdater<WebSessionStat> concurrentMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "concurrentMax");
    private volatile long requestCount;
    private volatile long requestErrorCount;
    private volatile long requestTimeNano;
    static final AtomicLongFieldUpdater<WebSessionStat> requestCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "requestCount");
    static final AtomicLongFieldUpdater<WebSessionStat> requestErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "requestErrorCount");
    static final AtomicLongFieldUpdater<WebSessionStat> requestTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "requestTimeNano");
    private volatile long jdbcFetchRowCount;
    private volatile long jdbcUpdateCount;
    private volatile long jdbcExecuteCount;
    private volatile long jdbcExecuteTimeNano;
    static final AtomicLongFieldUpdater<WebSessionStat> jdbcFetchRowCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "jdbcFetchRowCount");
    static final AtomicLongFieldUpdater<WebSessionStat> jdbcUpdateCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "jdbcUpdateCount");
    static final AtomicLongFieldUpdater<WebSessionStat> jdbcExecuteCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "jdbcExecuteCount");
    static final AtomicLongFieldUpdater<WebSessionStat> jdbcExecuteTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "jdbcExecuteTimeNano");
    private volatile long jdbcCommitCount;
    private volatile long jdbcRollbackCount;
    static final AtomicLongFieldUpdater<WebSessionStat> jdbcCommitCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "jdbcCommitCount");
    static final AtomicLongFieldUpdater<WebSessionStat> jdbcRollbackCountUpdater = AtomicLongFieldUpdater.newUpdater(WebSessionStat.class, "jdbcRollbackCount");
    private long createTimeMillis = -1L;
    private volatile long lastAccessTimeMillis = -1L;
    private String remoteAddresses;
    private String principal;
    private String userAgent;
    private volatile int requestIntervalHistogram_0_1;
    private volatile int requestIntervalHistogram_1_10;
    private volatile int requestIntervalHistogram_10_100;
    private volatile int requestIntervalHistogram_100_1000;
    private volatile int requestIntervalHistogram_1000_10000;
    private volatile int requestIntervalHistogram_10000_100000;
    private volatile int requestIntervalHistogram_100000_1000000;
    private volatile int requestIntervalHistogram_1000000_10000000;
    private volatile int requestIntervalHistogram_10000000_more;
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_0_1_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_0_1");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_1_10_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_1_10");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_10_100");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_100_1000");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_1000_10000");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_10000_100000");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_100000_1000000");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_1000000_10000000_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_1000000_10000000");
    static final AtomicIntegerFieldUpdater<WebSessionStat> requestIntervalHistogram_10000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(WebSessionStat.class, "requestIntervalHistogram_10000000_more");

    public WebSessionStat(String sessionId) {
        this.sessionId = sessionId;
    }

    public void reset() {
        concurrentMaxUpdater.set(this, 0);
        requestCountUpdater.set(this, 0L);
        requestErrorCountUpdater.set(this, 0L);
        requestTimeNanoUpdater.set(this, 0L);
        jdbcFetchRowCountUpdater.set(this, 0L);
        jdbcUpdateCountUpdater.set(this, 0L);
        jdbcExecuteCountUpdater.set(this, 0L);
        jdbcExecuteTimeNanoUpdater.set(this, 0L);
        jdbcCommitCountUpdater.set(this, 0L);
        jdbcRollbackCountUpdater.set(this, 0L);
        this.remoteAddresses = null;
        this.principal = null;
        requestIntervalHistogram_0_1_Updater.set(this, 0);
        requestIntervalHistogram_1_10_Updater.set(this, 0);
        requestIntervalHistogram_10_100_Updater.set(this, 0);
        requestIntervalHistogram_100_1000_Updater.set(this, 0);
        requestIntervalHistogram_1000_10000_Updater.set(this, 0);
        requestIntervalHistogram_10000_100000_Updater.set(this, 0);
        requestIntervalHistogram_100000_1000000_Updater.set(this, 0);
        requestIntervalHistogram_1000000_10000000_Updater.set(this, 0);
        requestIntervalHistogram_10000000_more_Updater.set(this, 0);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getCreateTimeMillis() {
        return this.createTimeMillis;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setCreateTimeMillis(long createTimeMillis) {
        this.createTimeMillis = createTimeMillis;
    }

    public long getLastAccessTimeMillis() {
        return this.lastAccessTimeMillis;
    }

    public String getRemoteAddress() {
        return this.remoteAddresses;
    }

    public void setLastAccessTimeMillis(long lastAccessTimeMillis) {
        if (this.lastAccessTimeMillis > 0L) {
            long interval = lastAccessTimeMillis - this.lastAccessTimeMillis;
            this.requestIntervalHistogramRecord(interval);
        }
        this.lastAccessTimeMillis = lastAccessTimeMillis;
    }

    private void requestIntervalHistogramRecord(long nanoSpan) {
        long millis = nanoSpan / 1000L / 1000L;
        if (millis < 1L) {
            requestIntervalHistogram_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            requestIntervalHistogram_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            requestIntervalHistogram_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            requestIntervalHistogram_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            requestIntervalHistogram_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            requestIntervalHistogram_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            requestIntervalHistogram_100000_1000000_Updater.incrementAndGet(this);
        } else if (millis < 10000000L) {
            requestIntervalHistogram_1000000_10000000_Updater.incrementAndGet(this);
        } else {
            requestIntervalHistogram_10000000_more_Updater.incrementAndGet(this);
        }
    }

    public void beforeInvoke() {
        int max;
        int running = runningCountUpdater.incrementAndGet(this);
        while (running > (max = concurrentMaxUpdater.get(this)) && !concurrentMaxUpdater.compareAndSet(this, max, running)) {
        }
        this.incrementRequestCount();
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.setLastAccessTimeMillis(requestStat.getStartMillis());
        }
    }

    public void incrementRequestCount() {
        requestCountUpdater.incrementAndGet(this);
    }

    public void afterInvoke(Throwable error, long nanos) {
        runningCountUpdater.decrementAndGet(this);
        this.reacord(nanos);
    }

    public void reacord(long nanos) {
        requestTimeNanoUpdater.addAndGet(this, nanos);
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.addJdbcExecuteCount(requestStat.getJdbcExecuteCount());
            this.addJdbcFetchRowCount(requestStat.getJdbcFetchRowCount());
            this.addJdbcUpdateCount(requestStat.getJdbcUpdateCount());
            this.addJdbcCommitCount(requestStat.getJdbcCommitCount());
            this.addJdbcRollbackCount(requestStat.getJdbcRollbackCount());
            this.addJdbcExecuteTimeNano(requestStat.getJdbcExecuteTimeNano());
        }
    }

    public void addRemoteAddress(String ip) {
        if (ip == null || ip.length() < 7) {
            return;
        }
        if (this.remoteAddresses == null) {
            this.remoteAddresses = ip;
            return;
        }
        if (this.remoteAddresses.equals(ip)) {
            return;
        }
        if (this.remoteAddresses.startsWith(ip + ';')) {
            return;
        }
        String addedIp = ';' + ip;
        if (this.remoteAddresses.endsWith(addedIp)) {
            return;
        }
        if (this.remoteAddresses.contains(';' + ip + ';')) {
            return;
        }
        if (this.remoteAddresses.length() > 256) {
            return;
        }
        this.remoteAddresses = this.remoteAddresses + addedIp;
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public long getConcurrentMax() {
        return this.concurrentMax;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getRequestErrorCount() {
        return this.requestErrorCount;
    }

    public long getRequestTimeNano() {
        return this.requestTimeNano;
    }

    public void addJdbcFetchRowCount(long delta) {
        jdbcFetchRowCountUpdater.addAndGet(this, delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount;
    }

    public void addJdbcUpdateCount(long updateCount) {
        jdbcUpdateCountUpdater.addAndGet(this, updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount;
    }

    public void incrementJdbcExecuteCount() {
        jdbcExecuteCountUpdater.incrementAndGet(this);
    }

    public void addJdbcExecuteCount(long executeCount) {
        jdbcExecuteCountUpdater.addAndGet(this, executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano;
    }

    public void addJdbcExecuteTimeNano(long nano) {
        jdbcExecuteTimeNanoUpdater.addAndGet(this, nano);
    }

    public void incrementJdbcCommitCount() {
        jdbcCommitCountUpdater.incrementAndGet(this);
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount;
    }

    public void addJdbcCommitCount(long commitCount) {
        jdbcCommitCountUpdater.addAndGet(this, commitCount);
    }

    public void incrementJdbcRollbackCount() {
        jdbcRollbackCountUpdater.incrementAndGet(this);
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount;
    }

    public void addJdbcRollbackCount(long rollbackCount) {
        jdbcRollbackCountUpdater.addAndGet(this, rollbackCount);
    }

    public long[] getRequestInterval() {
        return new long[]{this.requestIntervalHistogram_0_1, this.requestIntervalHistogram_1_10, this.requestIntervalHistogram_10_100, this.requestIntervalHistogram_100_1000, this.requestIntervalHistogram_1000_10000, this.requestIntervalHistogram_10000_100000, this.requestIntervalHistogram_100000_1000000, this.requestIntervalHistogram_1000000_10000000, this.requestIntervalHistogram_10000000_more};
    }

    public Map<String, Object> getStatData() {
        return this.getValue(false).getStatData();
    }

    public WebSessionStatValue getValue(boolean reset) {
        WebSessionStatValue val = new WebSessionStatValue();
        val.sessionId = this.sessionId;
        val.runningCount = this.getRunningCount();
        val.concurrentMax = JdbcSqlStatUtils.get(this, concurrentMaxUpdater, reset);
        val.requestCount = JdbcSqlStatUtils.get(this, requestCountUpdater, reset);
        val.requestErrorCount = JdbcSqlStatUtils.get(this, requestErrorCountUpdater, reset);
        val.requestTimeNano = JdbcSqlStatUtils.get(this, requestTimeNanoUpdater, reset);
        val.jdbcFetchRowCount = JdbcSqlStatUtils.get(this, jdbcFetchRowCountUpdater, reset);
        val.jdbcUpdateCount = JdbcSqlStatUtils.get(this, jdbcUpdateCountUpdater, reset);
        val.jdbcExecuteCount = JdbcSqlStatUtils.get(this, jdbcExecuteCountUpdater, reset);
        val.jdbcExecuteTimeNano = JdbcSqlStatUtils.get(this, jdbcExecuteTimeNanoUpdater, reset);
        val.jdbcCommitCount = JdbcSqlStatUtils.get(this, jdbcCommitCountUpdater, reset);
        val.jdbcRollbackCount = JdbcSqlStatUtils.get(this, jdbcRollbackCountUpdater, reset);
        val.createTimeMillis = this.createTimeMillis;
        val.lastAccessTimeMillis = this.lastAccessTimeMillis;
        val.remoteAddress = this.remoteAddresses;
        val.principal = this.principal;
        val.userAgent = this.userAgent;
        val.requestIntervalHistogram_0_1 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_0_1_Updater, reset);
        val.requestIntervalHistogram_1_10 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_1_10_Updater, reset);
        val.requestIntervalHistogram_10_100 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_10_100_Updater, reset);
        val.requestIntervalHistogram_100_1000 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_100_1000_Updater, reset);
        val.requestIntervalHistogram_1000_10000 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_1000_10000_Updater, reset);
        val.requestIntervalHistogram_10000_100000 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_10000_100000_Updater, reset);
        val.requestIntervalHistogram_100000_1000000 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_100000_1000000_Updater, reset);
        val.requestIntervalHistogram_1000000_10000000 = JdbcSqlStatUtils.get(this, requestIntervalHistogram_1000000_10000000_Updater, reset);
        val.requestIntervalHistogram_10000000_more = JdbcSqlStatUtils.get(this, requestIntervalHistogram_10000000_more_Updater, reset);
        return val;
    }
}

