/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.handler;

import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.NodeMainSpec;
import com.aliyun.migration.spec.domain.dataworks.WorkflowMainSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ElementKind;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.DwNewideClient;
import com.aliyun.migration.workflow.migration.dw.newide.converter.workflow.WorkflowConverter;
import com.aliyun.migration.workflow.migration.dw.newide.tools.DataWorksTopologicalUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowSubmiter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowSubmiter.class);
    private WorkflowProjectPackage workflowProjectPackage;
    private TaskContext taskContext;
    protected DataWorksNodeTypeUtils dataWorksNodeTypeUtils;
    protected DwNewideClient client;
    protected Boolean crazyMode = false;

    public WorkflowSubmiter(WorkflowProjectPackage workflowProjectPackage, TaskContext taskContext, DataWorksNodeTypeUtils dataWorksNodeTypeUtils, DwNewideClient client, Boolean crazyMode) {
        this.workflowProjectPackage = workflowProjectPackage;
        this.taskContext = taskContext;
        this.dataWorksNodeTypeUtils = dataWorksNodeTypeUtils;
        this.client = client;
        this.crazyMode = crazyMode;
    }

    public void importWorkflows() {
        WorkflowProject workflowProject = this.workflowProjectPackage.getWorkflowProject();
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        StatisticOp statisticOp = this.taskContext.getStatisticOp();
        statisticOp.addWorkflowTotal(workflowList.size());
        HashMap<String, List> existedWorkflowInProject = new HashMap<String, List>();
        Integer wfIndex = 1;
        ArrayList<String> workflowIdSortList = new ArrayList<String>();
        HashMap<String, Set<String>> downstreamDependencies = new HashMap<String, Set<String>>();
        DataWorksTopologicalUtils.sortWorkflowByDependency4OrginalId(this.workflowProjectPackage, this.dataWorksNodeTypeUtils, workflowIdSortList, downstreamDependencies);
        HashMap<String, Workflow> workflowMap = new HashMap<String, Workflow>();
        for (Workflow workflow : workflowList) {
            workflowMap.put(workflow.getWorkflowId(), workflow);
        }
        for (String workflowId : workflowIdSortList) {
            WorkflowMainSpec workflowSingleSpec;
            CycleWorkflowSingleSpec existTargetWorkflow;
            Workflow workflow = (Workflow)workflowMap.get(workflowId);
            log.info("[WRITE-WORKFLOW]({}/{})", (Object)wfIndex, (Object)workflowList.size());
            Integer n = wfIndex;
            wfIndex = wfIndex + 1;
            if (!existedWorkflowInProject.containsKey(workflow.getProjectId())) {
                log.info("\u4e3a\u5224\u65ad\u521b\u5efa/\u66f4\u65b0\uff0c\u83b7\u53d6project\u4e0b\u5df2\u7ecf\u5b58\u5728\u7684workflow");
                existedWorkflowInProject.put(workflow.getProjectId(), this.client.listWorkflowMainSpec(workflow.getProjectId(), Boolean.valueOf(false)));
            }
            WorkflowConverter workflowConverter = new WorkflowConverter(this.workflowProjectPackage, BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()), this.dataWorksNodeTypeUtils);
            if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("spec")) {
                existTargetWorkflow = this.getExistTargetWorkflowSpec((List)existedWorkflowInProject.get(workflow.getProjectId()), workflow, true);
                workflowSingleSpec = workflowConverter.convertWorkflow4Mx(workflow, existTargetWorkflow);
            } else {
                existTargetWorkflow = this.getExistTargetWorkflowSpec((List)existedWorkflowInProject.get(workflow.getProjectId()), workflow, false);
                workflowSingleSpec = workflowConverter.convertWorkflow(workflow, existTargetWorkflow);
            }
            if (((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getCitable() == null) {
                ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).setCitable(Boolean.valueOf(false));
                ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getTrigger().setType("Scheduler");
            }
            for (Workflow wf : workflowList) {
                for (WorkflowNode node : wf.getWorkflowNodes()) {
                    if (!this.dataWorksNodeTypeUtils.getNodeType(node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS) || StringUtils.isBlank((CharSequence)node.getScript()) || !node.getScript().equals(workflow.getWorkflowId()) && (workflow.getTWorkflowId() == null || !node.getScript().equals(workflow.getTWorkflowId()))) continue;
                    ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).setCitable(Boolean.valueOf(true));
                    ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getTrigger().setType("None");
                    break;
                }
                if (!((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getCitable().booleanValue()) continue;
                break;
            }
            boolean isForeach = false;
            for (Workflow wf : workflowList) {
                for (WorkflowNode node : wf.getWorkflowNodes()) {
                    if (!this.dataWorksNodeTypeUtils.getNodeType(node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.CONTROLLER_TRAVERSE) || StringUtils.isBlank((CharSequence)node.getScript()) || !node.getScript().equals(workflow.getWorkflowId())) continue;
                    isForeach = true;
                    break;
                }
                if (!isForeach) continue;
                break;
            }
            if (isForeach) {
                log.info("Foreach\u8282\u70b9\u5185\u90e8Workflow\uff0c\u8df3\u8fc7\u521b\u5efa");
                continue;
            }
            this.saveSpec(workflow, workflowSingleSpec);
            if (existTargetWorkflow == null) {
                this.importWorkflow(workflow, workflowSingleSpec);
            } else {
                this.importWorkflowForUpdate(workflow, workflowSingleSpec);
            }
            workflow.getCustomProperties().put("spec", WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)workflowSingleSpec).toJSONString(new JSONWriter.Feature[0]));
        }
        log.info("[WRITE-WORKFLOW] DONE");
    }

    private CycleWorkflowSingleSpec getExistTargetWorkflowSpec(List<WorkflowMainSpec> exsitedWorkflowList, Workflow workflow, Boolean isMx) {
        Object uploadPath;
        for (WorkflowMainSpec exsitWf : exsitedWorkflowList) {
            if (!exsitWf.getSpec().getId().equals(workflow.getTWorkflowId())) continue;
            return (CycleWorkflowSingleSpec)exsitWf.getSpec().getWorkflows().get(0);
        }
        if (workflow.getCustomProperties() == null) {
            workflow.setCustomProperties(new HashMap());
        }
        if (isMx.booleanValue()) {
            uploadPath = workflow.getWorkflowName();
        } else if (workflow.getCategoryValue() != null) {
            String workflowPath = workflow.getCategoryValue();
            if (workflowPath.endsWith(workflow.getWorkflowName())) {
                workflowPath = workflowPath.substring(0, workflowPath.length() - workflow.getWorkflowName().length());
            }
            if (workflowPath.endsWith("/")) {
                workflowPath.substring(0, workflowPath.length() - 1);
            }
            uploadPath = workflowPath + "/" + WorkflowConverter.nameStandard(workflow.getWorkflowName());
            if (((String)(uploadPath = ((String)uploadPath).replaceAll("/+", "/"))).startsWith("/")) {
                uploadPath = ((String)uploadPath).substring(1);
            }
        } else {
            uploadPath = WorkflowConverter.nameStandard(workflow.getWorkflowName());
        }
        for (WorkflowMainSpec exsitWf : exsitedWorkflowList) {
            if (!((CycleWorkflowSingleSpec)exsitWf.getSpec().getWorkflows().get(0)).getScript().getPath().equals(uploadPath)) continue;
            return (CycleWorkflowSingleSpec)exsitWf.getSpec().getWorkflows().get(0);
        }
        return null;
    }

    private void saveSpec(Workflow workflow, WorkflowMainSpec spec) {
        Workflow targetWf = (Workflow)WorkflowMainSpec.getWorkflowList((WorkflowMainSpec)spec).get(0);
        if (!StringUtils.equals((CharSequence)targetWf.getWorkflowId(), (CharSequence)workflow.getWorkflowId())) {
            workflow.setTWorkflowId(targetWf.getWorkflowId());
        }
        workflow.setOwner(targetWf.getOwner());
        workflow.setDescription(targetWf.getDescription());
        workflow.setTriggers(targetWf.getTriggers());
        workflow.setParamMap(targetWf.getParamMap());
        workflow.setCustomProperties(targetWf.getCustomProperties());
        if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("MigrationOriginalId")) {
            workflow.getCustomProperties().remove("MigrationOriginalId");
        }
        workflow.setTriggers(targetWf.getTriggers());
        for (WorkflowNode node : workflow.getWorkflowNodes()) {
            NodeSingleSpec targetNode = WorkflowConverter.findExistedNode(node, ((CycleWorkflowSingleSpec)spec.getSpec().getWorkflows().get(0)).getNodes());
            if (targetNode == null) continue;
            WorkflowNode resultNode = NodeSingleSpec.getWorkflowNode((NodeSingleSpec)targetNode);
            if (!StringUtils.equals((CharSequence)resultNode.getNodeId(), (CharSequence)node.getNodeId())) {
                node.setTNodeId(resultNode.getNodeId());
            }
            node.setNodeName(resultNode.getNodeName());
            node.setOwner(resultNode.getOwner());
            node.setDescription(resultNode.getDescription());
            node.setTrigger(resultNode.getTrigger());
            node.setRuntimeResource(resultNode.getRuntimeResource());
            node.setState(resultNode.getState());
            node.setTimeout(resultNode.getTimeout());
            node.setInstanceMode(resultNode.getInstanceMode());
            node.setRerunMode(resultNode.getRerunMode());
            node.setCustomProperties(resultNode.getCustomProperties());
            node.setRerunTimes(resultNode.getRerunTimes());
            node.setRerunInterval(resultNode.getRerunInterval());
            node.setParamMap(resultNode.getParamMap());
            if (node.getCustomProperties() == null || !node.getCustomProperties().containsKey("MigrationOriginalId")) continue;
            node.getCustomProperties().remove("MigrationOriginalId");
        }
    }

    private void importWorkflow(Workflow workflow, WorkflowMainSpec spec) {
        log.info("import workflow projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
        WorkflowMainSpec result = null;
        String targetId = null;
        try {
            this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
            targetId = this.client.importWorkflowDefinition(workflow.getProjectId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)spec).toJSONString(new JSONWriter.Feature[0]));
            if (this.crazyMode.booleanValue()) {
                log.info("\u75af\u72c2\u6a21\u5f0f\u5f00\u542f\uff0c\u8df3\u8fc7\u5bfc\u5165\u7ed3\u679c\u7684\u68c0\u9a8c");
                workflow.setTWorkflowId(targetId);
                return;
            }
            this.client.waitingForComplete();
            result = WorkflowMainSpec.getWorkflowMainSpec((String)this.client.getWorkflowDefinition(workflow.getProjectId(), targetId, Boolean.valueOf(false)).getBody().getWorkflowDefinition().getSpec());
        }
        catch (Exception e) {
            log.error("create workflow error projectId={} workflowName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), e});
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), e.getMessage());
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "import workflow error"));
            return;
        }
        if (result == null) {
            log.error("create workflow error projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
            String errorMsg = this.client.getDwNewideAsyncJobLogByElementId(targetId).getErrorMsg();
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), errorMsg);
            workflow.getWorkflowNodes().forEach(node -> {
                if (this.dataWorksNodeTypeUtils.getNodeType(node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS)) {
                    return;
                }
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "import workflow error: " + errorMsg);
            });
        } else {
            workflow.setTWorkflowId(result.getSpec().getId());
            this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            this.saveSpec(workflow, result);
            for (WorkflowNode node2 : workflow.getWorkflowNodes()) {
                if (!StringUtils.isEmpty((CharSequence)node2.getTNodeId())) {
                    this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node2.getNodeId());
                    continue;
                }
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(node2.getNodeId(), "import workflow error: " + this.client.getDwNewideAsyncJobLogByElementId(targetId).getErrorMsg());
            }
        }
    }

    private void importWorkflowForUpdate(Workflow workflow, WorkflowMainSpec spec) {
        log.info("update workflow projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
        WorkflowMainSpec result = null;
        String targetId = null;
        try {
            this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
            targetId = this.client.importWorkflowDefinition(workflow.getProjectId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)spec).toJSONString(new JSONWriter.Feature[0]));
            if (this.crazyMode.booleanValue()) {
                log.info("\u75af\u72c2\u6a21\u5f0f\u5f00\u542f\uff0c\u8df3\u8fc7\u5bfc\u5165\u7ed3\u679c\u7684\u68c0\u9a8c");
                workflow.setTWorkflowId(targetId);
                return;
            }
            this.client.waitingForComplete();
            result = WorkflowMainSpec.getWorkflowMainSpec((String)this.client.getWorkflowDefinition(workflow.getProjectId(), targetId, Boolean.valueOf(false)).getBody().getWorkflowDefinition().getSpec());
        }
        catch (Exception e) {
            log.error("update workflow error projectId={} workflowName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), e});
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), e.getMessage());
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "update workflow error: " + e.getMessage()));
            return;
        }
        String errorMsg = this.client.getDwNewideAsyncJobLogByElementId(targetId).getErrorMsg();
        if (errorMsg != null) {
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), "update workflow error (\u53ef\u80fd\u662f\u90e8\u5206\u66f4\u65b0\u9519\u8bef\uff0c\u9700\u8981\u4eba\u5de5\u6838\u5bf9): " + errorMsg);
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "update workflow error (\u53ef\u80fd\u662f\u90e8\u5206\u66f4\u65b0\u9519\u8bef\uff0c\u9700\u8981\u4eba\u5de5\u6838\u5bf9): " + errorMsg));
        } else {
            this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node.getNodeId()));
        }
        if (result != null) {
            this.saveSpec(workflow, result);
        }
    }

    public void updateWorkflow(Workflow workflow, CycleWorkflowSingleSpec workflowSingleSpec, CycleWorkflowSingleSpec exsitedWorkflowSingleSpec) {
        log.info("update workflow projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
        try {
            WorkflowMainSpec spec = new WorkflowMainSpec();
            spec.setVersion("1.1.0");
            spec.setKind(ElementKind.CYCLE_WORKFLOW);
            spec.setSpec(new CycleWorkflowBatchSpec());
            spec.getSpec().setName(workflow.getWorkflowName());
            spec.getSpec().setType(ElementKind.CYCLE_WORKFLOW);
            spec.getSpec().setWorkflows(List.of(workflowSingleSpec));
            if (this.client.updateWorkflowDefinition(workflow.getProjectId(), workflowSingleSpec.getId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)spec).toJSONString(new JSONWriter.Feature[0])).booleanValue()) {
                workflow.setTWorkflowId(workflowSingleSpec.getId());
                this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            } else {
                this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), "update workflow error");
            }
        }
        catch (Exception e) {
            log.error("update workflow error projectId={} workflowName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), e});
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), e.getMessage());
        }
        if (workflow.getWorkflowNodes() == null || workflow.getWorkflowNodes().size() == 0) {
            return;
        }
        this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
        ArrayList existedNodeIdList = new ArrayList();
        exsitedWorkflowSingleSpec.getNodes().forEach(node -> existedNodeIdList.add(node.getId()));
        for (NodeSingleSpec nodeSingleSpec : workflowSingleSpec.getNodes()) {
            try {
                NodeMainSpec nodeMainSpec = new NodeMainSpec();
                nodeMainSpec.setVersion("1.1.0");
                nodeMainSpec.setKind(ElementKind.NODE);
                nodeMainSpec.setSpec(List.of(nodeSingleSpec));
                if (!existedNodeIdList.contains(nodeSingleSpec.getId())) {
                    if (nodeSingleSpec.getSubflow() != null) continue;
                    log.info("create node projectId={} workflowName={} nodeName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()});
                    String nodeId = this.client.createNode(workflow.getProjectId(), workflowSingleSpec.getId(), NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0]));
                    WorkflowNode node2 = WorkflowConverter.findBwmNode(nodeSingleSpec, workflow.getWorkflowNodes());
                    if (node2 != null) {
                        node2.setTNodeId(nodeId);
                        this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node2.getNodeId() + "_" + node2.getNodeName());
                        continue;
                    }
                    this.taskContext.getStatisticOp().addWorkflowNodeFailure(nodeSingleSpec.getId(), String.format("create node error projectId=%s workflowName=%s nodeName=%s", workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()));
                    continue;
                }
                if (nodeSingleSpec.getSubflow() != null) continue;
                log.info("update node projectId={} workflowName={} nodeName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()});
                if (this.client.updateNode(workflow.getProjectId(), nodeSingleSpec.getId(), NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0])).booleanValue()) {
                    WorkflowNode node3 = WorkflowConverter.findBwmNode(nodeSingleSpec, workflow.getWorkflowNodes());
                    node3.setTNodeId(nodeSingleSpec.getId());
                    this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node3.getNodeId());
                    continue;
                }
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(nodeSingleSpec.getId(), String.format("update node error projectId=%s workflowName=%s nodeName=%s", workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()));
            }
            catch (Exception e) {
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(nodeSingleSpec.getId(), String.format("create node error projectId=%s workflowName=%s nodeName=%s", workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()));
            }
        }
    }
}

