/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.node;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.common.DatasourceSpec;
import com.aliyun.migration.spec.domain.dataworks.common.RuntimeResourceSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ScriptSpec;
import com.aliyun.migration.spec.domain.dataworks.common.TriggerSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.NodeOutputSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.OutputBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.AbstractNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.workflow.WorkflowConverter;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeConverter
extends AbstractNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeConverter.class);
    protected String pre_node_output_format = "%s_out";
    protected String node_output_format = "%s.%s_out";

    @Override
    public NodeSingleSpec convert(WorkflowNode workflowNode, NodeSingleSpec existedNode) {
        String schedulerType;
        NodeSingleSpec spec = new NodeSingleSpec();
        if (existedNode != null) {
            spec = (NodeSingleSpec)BwmJsonUtil.deepCopy((Object)existedNode, NodeSingleSpec.class);
        } else {
            spec.setId(workflowNode.getNodeId());
            existedNode = new NodeSingleSpec();
        }
        if (workflowNode.getCustomProperties() == null) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (workflowNode.getRuntimeResource() == null) {
            workflowNode.setRuntimeResource(new HashMap());
        }
        spec.setName(this.nameStandard(workflowNode.getNodeName()));
        if (workflowNode.getOwner() != null) {
            spec.setOwner(workflowNode.getOwner());
        } else if (existedNode != null) {
            spec.setOwner(existedNode.getOwner());
        }
        if (!StringUtils.isEmpty((CharSequence)workflowNode.getDescription())) {
            spec.setDescription(workflowNode.getDescription());
        }
        ArrayList<ScriptSpec.ScriptParameterSpec> parameters = new ArrayList<ScriptSpec.ScriptParameterSpec>();
        if (workflowNode.getParamMap() != null) {
            ArrayList keys = new ArrayList();
            workflowNode.getParamMap().keySet().forEach(keys::add);
            Collections.sort(keys);
            for (String key : keys) {
                if (workflowNode.getParamMap().get(key) == null) continue;
                ScriptSpec.ScriptParameterSpec scriptParameterSpec = new ScriptSpec.ScriptParameterSpec();
                scriptParameterSpec.setType("Constant");
                scriptParameterSpec.setScope("NodeParameter");
                scriptParameterSpec.setName(key);
                if (workflowNode.getParamMap().get(key) != null) {
                    scriptParameterSpec.setValue(workflowNode.getParamMap().get(key).toString());
                } else {
                    scriptParameterSpec.setValue("");
                }
                parameters.add(scriptParameterSpec);
            }
            if (spec.getScript() == null) {
                spec.setScript(new ScriptSpec());
            }
            spec.getScript().setParameters(parameters);
        }
        if (workflowNode.getTimeout() != null) {
            spec.setTimeout(workflowNode.getTimeout());
        }
        if ((schedulerType = (String)this.taskContextConf.getValue("scheduler.type", (Object)(workflowNode.getState() != null ? workflowNode.getState().name() : null), (Object)"NORMAL", String.class, BwmServiceErrorCode.CONFIG_ERROR)) != null) {
            switch (schedulerType) {
                case "NORMAL": {
                    spec.setRecurrence("Normal");
                    break;
                }
                case "PAUSE": {
                    spec.setRecurrence("Pause");
                    break;
                }
                case "SKIP": {
                    spec.setRecurrence("Skip");
                    break;
                }
                case "MANUAL": {
                    log.info("TODO: \u624b\u52a8\u4efb\u52a1\u540e\u9762\u518d\u5904\u7406");
                    break;
                }
                default: {
                    spec.setRecurrence("Normal");
                    break;
                }
            }
        } else {
            spec.setRecurrence("Normal");
        }
        if (((Boolean)this.taskContextConf.getValue("startImmediately", (Object)((Boolean)workflowNode.getCustomProperties().get("startImmediately")), (Object)BwmCommonConstant.Dataworks.START_IMMEDIATELY_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR)).booleanValue()) {
            spec.setInstanceMode("Immediately");
        } else {
            spec.setInstanceMode("T+1");
        }
        switch (RerunMode.getByValue((int)((Integer)this.taskContextConf.getValue("rerun.mode", (Object)((Integer)workflowNode.getCustomProperties().get("rerun.mode")), (Object)BwmCommonConstant.Dataworks.RERUN_MODE_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR)))) {
            case ALL_ALLOWED: {
                spec.setRerunMode("Allowed");
                break;
            }
            case ALL_DENIED: {
                spec.setRerunMode("Denied");
                break;
            }
            case FAILURE_ALLOWED: {
                spec.setRerunMode("FailureAllowed");
                break;
            }
            case UNKNOWN: {
                spec.setRerunMode("Allowed");
            }
        }
        spec.setRerunTimes((Integer)this.taskContextConf.getValue("auto.rerun.times", (Object)workflowNode.getRerunTimes(), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_TIMES_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        spec.setRerunInterval((Integer)this.taskContextConf.getValue("auto.rerun.interval.millis", (Object)workflowNode.getRerunInterval(), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_INTERVAL_MILLIS_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        if (spec.getScript() == null) {
            spec.setScript(new ScriptSpec());
        }
        if (spec.getScript().getRuntime() == null) {
            spec.getScript().setRuntime(new HashMap());
        }
        spec.getScript().getRuntime().put("command", workflowNode.getNodeType());
        spec.getScript().getRuntime().put("commandTypeId", this.dataWorksNodeTypeUtils.getCode(workflowNode.getNodeType()));
        if (workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("workflow.schedule.cu")) {
            spec.getScript().getRuntime().put("cu", (String)workflowNode.getRuntimeResource().get("workflow.schedule.cu"));
        } else if (spec.getScript().getRuntime() != null && spec.getScript().getRuntime().containsKey("cu")) {
            spec.getScript().getRuntime().remove("cu");
        }
        if (workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("resource.group.image.id")) {
            JSONObject contaninerJsonObject = new JSONObject();
            contaninerJsonObject.put((Object)"imageId", workflowNode.getRuntimeResource().get("resource.group.image.id"));
            spec.getScript().getRuntime().put("container", contaninerJsonObject);
        } else if (spec.getScript().getRuntime() != null && spec.getScript().getRuntime().containsKey("container")) {
            spec.getScript().getRuntime().remove("container");
        }
        spec.getScript().setContent(workflowNode.getScript());
        spec.getScript().setLanguage(null);
        if (spec.getTrigger() == null) {
            spec.setTrigger(new TriggerSpec());
        }
        spec.getTrigger().setType("Scheduler");
        if (workflowNode.getTrigger() != null) {
            spec.getTrigger().setCron(WorkflowConverter.cronSta(workflowNode.getTrigger().getCron()));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if (!Objects.isNull(workflowNode.getTrigger().getStartTime())) {
                spec.getTrigger().setStartTime(workflowNode.getTrigger().getStartTime().format(formatter));
            } else {
                spec.getTrigger().setStartTime("1970-01-01 00:00:00");
            }
            if (!Objects.isNull(workflowNode.getTrigger().getEndTime())) {
                spec.getTrigger().setEndTime(workflowNode.getTrigger().getEndTime().format(formatter));
            } else {
                spec.getTrigger().setEndTime("9999-01-01 00:00:00");
            }
            if (workflowNode.getTrigger().getTimezone() != null) {
                spec.getTrigger().setTimezone(workflowNode.getTrigger().getTimezone().toString());
            } else {
                spec.getTrigger().setTimezone(ZoneId.systemDefault().toString());
            }
        }
        if (spec.getTrigger().getDelaySeconds() == null) {
            spec.getTrigger().setDelaySeconds(Integer.valueOf(0));
        }
        if (spec.getRuntimeResource() == null) {
            spec.setRuntimeResource(new RuntimeResourceSpec());
        }
        if (workflowNode.getRuntimeResource().containsKey("resource.group.identifier")) {
            spec.getRuntimeResource().setResourceGroup(((String)workflowNode.getRuntimeResource().get("resource.group.identifier")).toString());
        } else {
            String targetResourceGroup = (String)this.taskContextConf.getValue("resource.group.identifier", (Object)((String)workflowNode.getRuntimeResource().get("resource.group.identifier")), (Object)"", String.class, BwmServiceErrorCode.CONFIG_ERROR);
            if (spec.getRuntimeResource() == null && !StringUtils.isEmpty((CharSequence)targetResourceGroup)) {
                spec.setRuntimeResource(new RuntimeResourceSpec());
                spec.getRuntimeResource().setResourceGroup(targetResourceGroup);
            } else if (!StringUtils.isEmpty((CharSequence)targetResourceGroup)) {
                spec.getRuntimeResource().setResourceGroup(targetResourceGroup);
            } else {
                spec.getRuntimeResource().setResourceGroup(null);
            }
        }
        if (workflowNode.getCustomProperties().containsKey("datasource")) {
            spec.setDatasource(new DatasourceSpec());
            spec.getDatasource().setName((String)workflowNode.getCustomProperties().get("datasource"));
            DataWorksNodeTypeUtils.CustomCodeProgramType codeProgramType = this.dataWorksNodeTypeUtils.getNodeType(workflowNode.getNodeType());
            switch (codeProgramType.getCalcEngineType()) {
                case GENERAL: {
                    spec.getDatasource().setType(this.dataWorksNodeTypeUtils.getName(codeProgramType).toLowerCase());
                    break;
                }
                case ODPS: {
                    spec.getDatasource().setType("odps");
                    break;
                }
                case EMR: {
                    spec.getDatasource().setType("emr");
                    break;
                }
                case CLICKHOUSE: {
                    spec.getDatasource().setType("clickhouse");
                    break;
                }
                case ADB_MYSQL: {
                    spec.getDatasource().setType("adb_mysql");
                    break;
                }
                case HYBRIDDB_FOR_POSTGRESQL: {
                    spec.getDatasource().setType("hybriddb_for_postgresql");
                    break;
                }
                case DATABASE: {
                    spec.getDatasource().setType(this.dataWorksNodeTypeUtils.getName(codeProgramType).toLowerCase());
                }
            }
        }
        spec.setInputs(new OutputBatchSpec());
        spec.getInputs().setNodeOutputs(new ArrayList());
        spec.getInputs().setVariables(new ArrayList());
        if (workflowNode.getParentTargetIds() != null && workflowNode.getParentTargetIds().size() > 0) {
            for (String parentId : workflowNode.getParentTargetIds()) {
                NodeOutputSpec parentOutput = new NodeOutputSpec();
                parentOutput.setData(String.format(this.pre_node_output_format, parentId));
                parentOutput.setArtifactType("NodeOutput");
                spec.getInputs().getNodeOutputs().add(parentOutput);
            }
        } else {
            NodeOutputSpec parentOutput = new NodeOutputSpec();
            parentOutput.setData(String.format("%s_root", workflowNode.getProjectName()));
            spec.getInputs().getNodeOutputs().add(parentOutput);
        }
        spec.setOutputs(new OutputBatchSpec());
        spec.getOutputs().setNodeOutputs(new ArrayList());
        spec.getOutputs().setVariables(new ArrayList());
        NodeOutputSpec output = new NodeOutputSpec();
        output.setData(String.format(this.node_output_format, workflowNode.getProjectName(), workflowNode.getNodeId()));
        output.setArtifactType("NodeOutput");
        output.setIsDefault(Boolean.valueOf(true));
        spec.getOutputs().getNodeOutputs().add(output);
        return spec;
    }
}

