/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.node;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DefaultNodeConverter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DINodeConverter
extends DefaultNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(DINodeConverter.class);

    @Override
    public NodeSingleSpec convert(WorkflowNode workflowNode, NodeSingleSpec existedNode) {
        NodeSingleSpec result = super.convert(workflowNode, existedNode);
        try {
            String content = result.getScript().getContent();
            JSONObject contentJson = JSONObject.parseObject((String)content);
            if (!contentJson.containsKey("extend")) {
                contentJson.put((Object)"extend", (Object)new JSONObject());
            }
            if (!contentJson.getJSONObject("extend").containsKey("mode")) {
                contentJson.getJSONObject("extend").put((Object)"mode", (Object)"code");
            }
            if (workflowNode.getRuntimeResource() == null) {
                workflowNode.setRuntimeResource(new HashMap());
            }
            if (!contentJson.getJSONObject("extend").containsKey("resourceGroup")) {
                String targetDIResourceGroup = (String)this.taskContextConf.getValue("di.resource.group.identifier", (Object)((String)workflowNode.getRuntimeResource().get("di.resource.group.identifier")), (Object)"", String.class, BwmServiceErrorCode.CONFIG_ERROR);
                String targetResourceGroup = (String)this.taskContextConf.getValue("resource.group.identifier", (Object)((String)workflowNode.getRuntimeResource().get("resource.group.identifier")), (Object)"", String.class, BwmServiceErrorCode.CONFIG_ERROR);
                if (targetDIResourceGroup != null) {
                    contentJson.getJSONObject("extend").put((Object)"resourceGroup", (Object)targetDIResourceGroup);
                } else if (targetResourceGroup != null) {
                    contentJson.getJSONObject("extend").put((Object)"resourceGroup", (Object)targetResourceGroup);
                }
            }
            if (!contentJson.getJSONObject("extend").containsKey("cu")) {
                Float cu = (Float)this.taskContextConf.getValue("workflow.di.cu", workflowNode.getRuntimeResource().containsKey("workflow.di.cu") ? Float.valueOf(Float.parseFloat((String)workflowNode.getRuntimeResource().get("workflow.di.cu"))) : null, (Object)BwmCommonConstant.Dataworks.WORKFLOW_DI_CU_DEFAULT, Float.class, BwmServiceErrorCode.CONFIG_ERROR);
                contentJson.getJSONObject("extend").put((Object)"cu", (Object)cu);
            }
            contentJson.getJSONObject("extend").put((Object)"oneStopPageNum", (Object)2);
            result.getScript().setContent(contentJson.toJSONString(new JSONWriter.Feature[0]));
        }
        catch (Exception e) {
            log.error("get di content error, filled with template", (Throwable)e);
        }
        return result;
    }
}

