/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

class V8PropertyMap<V>
implements Map<String, V> {
    private Hashtable<String, V> map = new Hashtable();
    private Set<String> nulls = new HashSet<String>();

    V8PropertyMap() {
    }

    @Override
    public int size() {
        return this.map.size() + this.nulls.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() && this.nulls.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key) || this.nulls.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null && !this.nulls.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.nulls.contains(key)) {
            return null;
        }
        return this.map.get(key);
    }

    @Override
    public V put(String key, V value) {
        if (value == null) {
            if (this.map.containsKey(key)) {
                this.map.remove(key);
            }
            this.nulls.add(key);
            return null;
        }
        if (this.nulls.contains(key)) {
            this.nulls.remove(key);
        }
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.nulls.contains(key)) {
            this.nulls.remove(key);
            return null;
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.nulls.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>(this.map.keySet());
        result.addAll(this.nulls);
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>(this.map.values());
        for (int i = 0; i < this.nulls.size(); ++i) {
            result.add(null);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> result = new HashSet<Map.Entry<String, V>>(this.map.entrySet());
        for (String nullKey : this.nulls) {
            result.add(new AbstractMap.SimpleEntry<String, Object>(nullKey, null));
        }
        return result;
    }
}

