/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;
import org.datanucleus.util.Localiser;

public class TypeConverterMapping
extends SingleFieldMapping {
    TypeConverter converter;

    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        Class fieldType = clr.classForName(type);
        this.converter = storeMgr.getNucleusContext().getTypeManager().getDefaultTypeConverterForType(fieldType);
        if (this.converter == null) {
            throw new NucleusUserException("Unable to find TypeConverter for converting " + fieldType + " to String");
        }
        super.initialize(storeMgr, type);
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        this.initialize(mmd, table, clr, null);
    }

    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr, TypeConverter conv) {
        if (mmd.getTypeConverterName() != null) {
            this.converter = table.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
            if (this.converter == null) {
                throw new NucleusUserException(Localiser.msg((String)"044062", (Object[])new Object[]{mmd.getFullFieldName(), mmd.getTypeConverterName()}));
            }
        } else if (conv != null) {
            this.converter = conv;
        } else {
            throw new NucleusUserException("Unable to initialise mapping of type " + this.getClass().getName() + " for field " + mmd.getFullFieldName() + " since no TypeConverter was provided");
        }
        super.initialize(mmd, table, clr);
    }

    public TypeConverter getTypeConverter() {
        return this.converter;
    }

    @Override
    public int getDefaultLength(int index) {
        if (this.converter instanceof ColumnLengthDefiningTypeConverter) {
            return ((ColumnLengthDefiningTypeConverter)this.converter).getDefaultColumnLength(index);
        }
        return super.getDefaultLength(index);
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)this.getJavaType()).getName();
    }

    @Override
    public Class getJavaType() {
        return this.mmd != null ? this.mmd.getType() : this.storeMgr.getNucleusContext().getClassLoaderResolver(null).classForName(this.type);
    }

    protected void setDatastoreFromMemberValue(PreparedStatement ps, int[] exprIndex, Object memberValue) {
        Object convertedValue = this.converter.toDatastoreType(memberValue);
        if (convertedValue == null) {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
        } else if (convertedValue instanceof Boolean) {
            this.getDatastoreMapping(0).setBoolean(ps, exprIndex[0], (Boolean)convertedValue);
        } else if (convertedValue instanceof Byte) {
            this.getDatastoreMapping(0).setByte(ps, exprIndex[0], (Byte)convertedValue);
        } else if (convertedValue instanceof Character) {
            this.getDatastoreMapping(0).setChar(ps, exprIndex[0], ((Character)convertedValue).charValue());
        } else if (convertedValue instanceof Double) {
            this.getDatastoreMapping(0).setDouble(ps, exprIndex[0], (Double)convertedValue);
        } else if (convertedValue instanceof Float) {
            this.getDatastoreMapping(0).setFloat(ps, exprIndex[0], ((Float)convertedValue).floatValue());
        } else if (convertedValue instanceof Integer) {
            this.getDatastoreMapping(0).setInt(ps, exprIndex[0], (Integer)convertedValue);
        } else if (convertedValue instanceof Long) {
            this.getDatastoreMapping(0).setLong(ps, exprIndex[0], (Long)convertedValue);
        } else if (convertedValue instanceof Short) {
            this.getDatastoreMapping(0).setShort(ps, exprIndex[0], (Short)convertedValue);
        } else if (convertedValue instanceof String) {
            this.getDatastoreMapping(0).setString(ps, exprIndex[0], (String)convertedValue);
        } else {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], convertedValue);
        }
    }

    protected Object getMemberValueFromDatastore(ResultSet resultSet, int[] exprIndex) {
        Class datastoreType = TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, String.class);
        Object datastoreValue = null;
        datastoreValue = Boolean.class.isAssignableFrom(datastoreType) ? Boolean.valueOf(this.getDatastoreMapping(0).getBoolean(resultSet, exprIndex[0])) : (Byte.class.isAssignableFrom(datastoreType) ? Byte.valueOf(this.getDatastoreMapping(0).getByte(resultSet, exprIndex[0])) : (Character.class.isAssignableFrom(datastoreType) ? Character.valueOf(this.getDatastoreMapping(0).getChar(resultSet, exprIndex[0])) : (Double.class.isAssignableFrom(datastoreType) ? Double.valueOf(this.getDatastoreMapping(0).getDouble(resultSet, exprIndex[0])) : (Float.class.isAssignableFrom(datastoreType) ? Float.valueOf(this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0])) : (Integer.class.isAssignableFrom(datastoreType) ? Integer.valueOf(this.getDatastoreMapping(0).getInt(resultSet, exprIndex[0])) : (Long.class.isAssignableFrom(datastoreType) ? Long.valueOf(this.getDatastoreMapping(0).getLong(resultSet, exprIndex[0])) : (Short.class.isAssignableFrom(datastoreType) ? Short.valueOf(this.getDatastoreMapping(0).getShort(resultSet, exprIndex[0])) : (String.class.isAssignableFrom(datastoreType) ? this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]) : this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0])))))))));
        return this.converter.toMemberType(datastoreValue);
    }

    @Override
    public void setBoolean(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, boolean value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public boolean getBoolean(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return false;
        }
        return (Boolean)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setByte(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, byte value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public byte getByte(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        return (Byte)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setChar(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, char value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, Character.valueOf(value));
    }

    @Override
    public char getChar(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return '\u0000';
        }
        return ((Character)this.getMemberValueFromDatastore(resultSet, exprIndex)).charValue();
    }

    @Override
    public void setDouble(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, double value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public double getDouble(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0.0;
        }
        return (Double)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setFloat(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, float value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, Float.valueOf(value));
    }

    @Override
    public float getFloat(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0.0f;
        }
        return ((Float)this.getMemberValueFromDatastore(resultSet, exprIndex)).floatValue();
    }

    @Override
    public void setInt(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, int value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public int getInt(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        return (Integer)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setLong(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, long value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public long getLong(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0L;
        }
        return (Long)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setShort(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, short value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public short getShort(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        return (Short)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setString(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, String value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public String getString(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        return (String)this.getMemberValueFromDatastore(resultSet, exprIndex);
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (exprIndex == null) {
            return;
        }
        this.setDatastoreFromMemberValue(ps, exprIndex, value);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        return this.getMemberValueFromDatastore(resultSet, exprIndex);
    }
}

