/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Field;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class JacksonTypeHandler
extends AbstractJsonTypeHandler<Object> {
    private static ObjectMapper OBJECT_MAPPER;

    public JacksonTypeHandler(Class<?> type) {
        super(type);
    }

    public JacksonTypeHandler(Class<?> type, Field field) {
        super(type, field);
    }

    public Object parse(String json) {
        ObjectMapper objectMapper = JacksonTypeHandler.getObjectMapper();
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        JavaType javaType = typeFactory.constructType(this.getFieldType());
        try {
            return objectMapper.readValue(json, javaType);
        }
        catch (JacksonException e) {
            this.log.error("deserialize json: " + json + " to " + javaType + " error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toJson(Object obj) {
        try {
            return JacksonTypeHandler.getObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            this.log.error("serialize " + obj + " to json error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        if (null == OBJECT_MAPPER) {
            OBJECT_MAPPER = new ObjectMapper();
        }
        return OBJECT_MAPPER;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper should not be null", (Object[])new Object[0]);
        OBJECT_MAPPER = objectMapper;
    }
}

