/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.standard.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.standard.service.Code;
import java.io.Serializable;
import java.util.List;

public class ResultList<T>
implements Serializable {
    private static final long serialVersionUID = 7154887528070131284L;
    private String code;
    private Boolean success;
    private List<T> data;
    private String errMsg;
    private Integer errCode;
    private String requestId;
    private Integer currentPage;
    private Integer pageSize;
    private Integer totalNum;
    private Integer totalPages;

    public static <T> ResultList<T> of(String msg, Integer errCode, List<T> data, Boolean success, String sessionId, Integer currentPage, Integer pageSize, Integer totalNum) {
        ResultList<T> result = new ResultList<T>();
        result.setErrMsg(msg).setSuccess(success).setData(data).setErrCode(errCode).setRequestId(sessionId).setTotalNum(totalNum).setPageSize(pageSize).setCurrentPage(currentPage).setTotalPages((int)Math.ceil((float)totalNum.intValue() / (float)pageSize.intValue()));
        return result;
    }

    public static <T> ResultList<T> ofSuccess(List<T> data, Integer currentPage, Integer pageSize, Integer totalNum) {
        return ResultList.of(null, Code.SUCCESS.code, data, true, "", currentPage, pageSize, totalNum);
    }

    public static <T> ResultList<T> ofSuccess(List<T> data) {
        return ResultList.of(null, Code.SUCCESS.code, data, true, "", 1, data.size(), data.size());
    }

    public static <T> ResultList<T> ofError(String msg) {
        return ResultList.of(msg, Code.ERROR.code, null, true, "", 0, 0, 0);
    }

    public static <T> ResultList<T> ofError(String msg, String sessionId) {
        return ResultList.of(msg, Code.ERROR.code, null, true, sessionId, 0, 0, 0);
    }

    public static <T> ResultList<T> ofError(String msg, Integer code) {
        return ResultList.of(msg, code, null, true, "", 0, 0, 0);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultList;
    }

    public String toString() {
        return "ResultList(code=" + this.getCode() + ", success=" + this.getSuccess() + ", data=" + this.getData() + ", errMsg=" + this.getErrMsg() + ", errCode=" + this.getErrCode() + ", requestId=" + this.getRequestId() + ", currentPage=" + this.getCurrentPage() + ", pageSize=" + this.getPageSize() + ", totalNum=" + this.getTotalNum() + ", totalPages=" + this.getTotalPages() + ")";
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public List<T> getData() {
        return this.data;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getTotalNum() {
        return this.totalNum;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public ResultList<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public ResultList<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ResultList<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public ResultList<T> setErrMsg(String errMsg) {
        this.errMsg = errMsg;
        return this;
    }

    public ResultList<T> setErrCode(Integer errCode) {
        this.errCode = errCode;
        return this;
    }

    public ResultList<T> setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ResultList<T> setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    public ResultList<T> setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public ResultList<T> setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
        return this;
    }

    public ResultList<T> setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultList)) {
            return false;
        }
        ResultList other = (ResultList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Integer this$errCode = this.getErrCode();
        Integer other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$totalNum = this.getTotalNum();
        Integer other$totalNum = other.getTotalNum();
        if (this$totalNum == null ? other$totalNum != null : !((Object)this$totalNum).equals(other$totalNum)) {
            return false;
        }
        Integer this$totalPages = this.getTotalPages();
        Integer other$totalPages = other.getTotalPages();
        if (this$totalPages == null ? other$totalPages != null : !((Object)this$totalPages).equals(other$totalPages)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Integer $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $totalNum = this.getTotalNum();
        result = result * 59 + ($totalNum == null ? 43 : ((Object)$totalNum).hashCode());
        Integer $totalPages = this.getTotalPages();
        result = result * 59 + ($totalPages == null ? 43 : ((Object)$totalPages).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }
}

