/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.tools;

import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.PolicyException;
import com.alibaba.security.xss.richtext.XssXppScanner;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RichTextTool
extends JFrame {
    private static final long serialVersionUID = 4655434691393468705L;
    private JTextArea input;
    private JTextArea output;
    private JButton ok;
    private JButton cancel;
    private JButton clear;
    private Policy p;
    private XssXppScanner scanner;

    public RichTextTool() throws PolicyException {
        this.setTitle("XSS validate tools");
        this.setBounds(50, 50, 800, 600);
        this.init();
        this.pack();
        this.p = Policy.getStrictPolicyInstance();
        this.scanner = new XssXppScanner(this.p);
    }

    private void init() {
        JPanel root = new JPanel(new BorderLayout());
        this.input = new JTextArea();
        this.output = new JTextArea();
        this.input.setLineWrap(true);
        this.output.setLineWrap(true);
        this.input.setRows(10);
        this.input.setColumns(80);
        this.output.setRows(10);
        this.output.setColumns(80);
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.clear = new JButton("Clear");
        this.output.setEditable(false);
        JPanel up = new JPanel();
        up.add(new JScrollPane(this.input, 22, 31));
        JPanel center = new JPanel();
        center.add(new JScrollPane(this.output, 22, 32));
        JPanel down = new JPanel();
        JPanel butPan = new JPanel(new FlowLayout(0));
        butPan.add(this.clear);
        butPan.add(this.ok);
        butPan.add(this.cancel);
        down.add(butPan);
        root.add((Component)up, "North");
        root.add((Component)center, "Center");
        root.add((Component)down, "South");
        this.getContentPane().add(root);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String html = RichTextTool.this.input.getText();
                String s = RichTextTool.this.scanner.scan(html);
                if (s != null) {
                    if (s.length() == 0) {
                        RichTextTool.this.output.setText("all html was removed");
                    } else {
                        RichTextTool.this.output.setText(s);
                    }
                } else {
                    RichTextTool.this.output.setText("code bug, contact me:)");
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RichTextTool.this.input.setText("");
                RichTextTool.this.output.setText("");
            }
        });
        up.setOpaque(false);
        center.setOpaque(false);
        down.setOpaque(false);
        root.setBackground(Color.BLACK);
    }

    public static void main(String[] args) {
        try {
            RichTextTool frame = new RichTextTool();
            frame.setVisible(true);
        }
        catch (PolicyException e) {
            e.printStackTrace();
        }
    }
}

