/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.impl;

import com.alibaba.security.css.DefaultDocumentHandler;
import com.alibaba.security.css.selector.CSSSelector;
import com.alibaba.security.css.w3cinterface.CSSException;
import com.alibaba.security.css.w3cinterface.LexicalUnit;
import java.util.List;

public class CssDocument4TagHandler
extends DefaultDocumentHandler {
    private boolean selectorOpen = false;

    public CssDocument4TagHandler(StringBuilder buffer) {
        super(buffer);
    }

    public void endMedia(List<String> media) throws CSSException {
        this.styleSheet.append("}\r\n");
        this.selectorOpen = false;
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (!this.selectorOpen) {
            return;
        }
        super.property(name, value, important);
    }

    public void startMedia(List<String> media) throws CSSException {
        this.styleSheet.append("@media ");
        for (String m : media) {
            this.styleSheet.append(m).append(' ');
        }
        this.styleSheet.append('{');
        this.selectorOpen = true;
    }

    public void startSelector(List<CSSSelector> selectors) throws CSSException {
        int selectorCount = 0;
        for (int i = 0; i < selectors.size(); ++i) {
            String selectorName;
            CSSSelector selector = selectors.get(i);
            if (selector == null || (selectorName = selector.toString()).trim().length() == 0) continue;
            if (selectorCount > 0) {
                this.styleSheet.append(',');
                this.styleSheet.append(' ');
            }
            this.styleSheet.append(selectorName);
            ++selectorCount;
        }
        if (selectorCount > 0) {
            this.styleSheet.append(' ');
            this.styleSheet.append('{');
            this.selectorOpen = true;
        }
    }

    public void endSelector(List<CSSSelector> selectors) throws CSSException {
        if (this.selectorOpen) {
            this.styleSheet.append('}');
            this.styleSheet.append('\n');
        }
        this.selectorOpen = false;
    }
}

