/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext;

import com.alibaba.security.util.DetectDefinedChar;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.ScanException;
import com.alibaba.security.xss.richtext.XppScanner;
import com.alibaba.security.xss.richtext.impl.FragmentXppParser;
import com.alibaba.security.xss.richtext.impl.XssFilterDocumentHandler;
import com.alibaba.securitysdk.cyberneko.html.filters.Purifier;
import com.alibaba.securitysdk.org.apache.xerces.xni.parser.XMLDocumentFilter;
import com.alibaba.securitysdk.org.xml.sax.InputSource;
import com.alibaba.securitysdk.org.xml.sax.SAXException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public abstract class AbstractXppScanner
implements XppScanner {
    protected Policy policy = null;
    protected static final String NAMES_ELEMS_PROPERTY = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS_PROPERTY = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String FILTERS_PROPERTY = "http://cyberneko.org/html/properties/filters";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    static DetectDefinedChar detectXMLChar;

    public AbstractXppScanner(Policy policy) {
        this.policy = policy;
    }

    public String scan(String html) {
        if (html == null) {
            throw new ScanException("input html can not be null");
        }
        if (html.length() > this.policy.getMaxInputSize()) {
            throw new ScanException("input html reach max size: " + this.policy.getMaxInputSize());
        }
        if (this.policy.isUsePreXMLValid()) {
            html = this.stripNonValidXMLCharacters(html);
        }
        FragmentXppParser parser = new FragmentXppParser();
        if (this.policy.isElemsLower()) {
            parser.setProperty(NAMES_ELEMS_PROPERTY, "lower");
        } else {
            parser.setProperty(NAMES_ELEMS_PROPERTY, "upper");
        }
        if (this.policy.isAttrsLower()) {
            parser.setProperty(NAMES_ATTRS_PROPERTY, "lower");
        } else {
            parser.setProperty(NAMES_ATTRS_PROPERTY, "upper");
        }
        if (this.policy.isEnableNamespace()) {
            parser.setFeature(NAMESPACES, true);
        } else {
            parser.setFeature(NAMESPACES, false);
        }
        StringBuilder buffer = new StringBuilder(html.length() << 1);
        XssFilterDocumentHandler filter = new XssFilterDocumentHandler(buffer, this.policy);
        if (this.policy.isUsePurifier()) {
            Purifier p = new Purifier();
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{p, filter};
            parser.setProperty(FILTERS_PROPERTY, filters);
        } else {
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{filter};
            parser.setProperty(FILTERS_PROPERTY, filters);
        }
        InputSource input = new InputSource((Reader)new StringReader(html));
        try {
            parser.parse(input);
        }
        catch (SAXException e) {
            throw new ScanException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ScanException(e);
        }
        return buffer.toString();
    }

    protected String stripNonValidXMLCharacters(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder sb = null;
        int len = in.length();
        for (int i = 0; i < len; ++i) {
            char ch = in.charAt(i);
            if (detectXMLChar.isProhibitChar(ch)) {
                if (sb == null) continue;
                sb.append(ch);
                continue;
            }
            if (sb != null) continue;
            sb = new StringBuilder(len);
            sb.append(in, 0, i);
        }
        return sb == null ? in : sb.toString();
    }

    static {
        int i;
        detectXMLChar = new DetectDefinedChar();
        detectXMLChar.addProhibitChar(9);
        detectXMLChar.addProhibitChar(10);
        detectXMLChar.addProhibitChar(13);
        for (i = 32; i < 55296; ++i) {
            detectXMLChar.addProhibitChar(i);
        }
        for (i = 57344; i < 65534; ++i) {
            detectXMLChar.addProhibitChar(i);
        }
    }
}

