/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.json.compatible;

import com.alibaba.security.xss.XssEscape;
import com.alibaba.security.xss.XssEscapeImpl;
import com.alibaba.security.xss.json.JsonEscapeType;
import com.alibaba.security.xss.json.compatible.FastJsonEscape;
import com.alibaba.securitysdk.fastjson.JSON;
import com.alibaba.securitysdk.fastjson.JSONObject;
import com.alibaba.securitysdk.fastjson.serializer.JSONSerializer;
import com.alibaba.securitysdk.fastjson.serializer.NameFilter;
import com.alibaba.securitysdk.fastjson.serializer.SerializeWriter;
import com.alibaba.securitysdk.fastjson.serializer.SerializerFeature;
import com.alibaba.securitysdk.fastjson.serializer.ValueFilter;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class JsonEscapeByFastJson
implements FastJsonEscape {
    private XssEscape xssEscape;
    private static final SerializerFeature[] FEATURES = new SerializerFeature[5];
    private static final SerializerFeature[] UNI_FEATURES;
    private static final Map<JsonEscapeType, SerializerFeature[]> SERIALIZER_FEATURE_MAP;

    public JsonEscapeByFastJson() {
        this(new XssEscapeImpl());
    }

    public JsonEscapeByFastJson(XssEscape xssEscape) {
        this.xssEscape = xssEscape;
    }

    @Override
    public String escape(Object jsonObject, JsonEscapeType escapeType) {
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject instanceof JSONObject) {
            return this.innerEscape(jsonObject, escapeType);
        }
        if (jsonObject instanceof String) {
            return this.escape((String)jsonObject, escapeType);
        }
        return this.escape(jsonObject.toString(), escapeType);
    }

    @Override
    public String escape(String text, JsonEscapeType escapeType) {
        Object object;
        try {
            object = JSON.parse((String)text);
        }
        catch (Exception e) {
            return null;
        }
        return this.innerEscape(object, escapeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String innerEscape(Object jsonObject, JsonEscapeType escapeType) {
        try (SerializeWriter out = null;){
            SerializerFeature[] serializerFeatures = SERIALIZER_FEATURE_MAP.get(escapeType);
            out = new SerializeWriter(serializerFeatures == null ? FEATURES : serializerFeatures);
            JSONSerializer serialzer = this.getJsonSerializer(out, escapeType);
            serialzer.write(jsonObject);
            String string = out.toString();
            return string;
        }
    }

    private JSONSerializer getJsonSerializer(SerializeWriter out, JsonEscapeType escapeType) {
        JSONSerializer serialzer = new JSONSerializer(out);
        if (JsonEscapeType.ESCAPE_HTML == escapeType || JsonEscapeType.ESCAPE_HTML_WITHOUT_AMPERSAND == escapeType) {
            serialzer.getNameFilters().add(new MyNameFilter(escapeType));
            serialzer.getValueFilters().add(new MyValueFilter(escapeType));
        }
        return serialzer;
    }

    private String escapeHtml(String text, JsonEscapeType type) {
        if (type == JsonEscapeType.ESCAPE_HTML) {
            return this.xssEscape.escapeHtml(text);
        }
        if (type == JsonEscapeType.ESCAPE_HTML_WITHOUT_AMPERSAND) {
            return this.xssEscape.escapeHtmlWithoutAmpersand(text);
        }
        return null;
    }

    static {
        JsonEscapeByFastJson.FEATURES[0] = SerializerFeature.QuoteFieldNames;
        JsonEscapeByFastJson.FEATURES[1] = SerializerFeature.SkipTransientField;
        JsonEscapeByFastJson.FEATURES[2] = SerializerFeature.WriteEnumUsingToString;
        JsonEscapeByFastJson.FEATURES[3] = SerializerFeature.SortField;
        JsonEscapeByFastJson.FEATURES[4] = SerializerFeature.WriteMapNullValue;
        UNI_FEATURES = new SerializerFeature[6];
        JsonEscapeByFastJson.UNI_FEATURES[0] = SerializerFeature.QuoteFieldNames;
        JsonEscapeByFastJson.UNI_FEATURES[1] = SerializerFeature.SkipTransientField;
        JsonEscapeByFastJson.UNI_FEATURES[2] = SerializerFeature.WriteEnumUsingToString;
        JsonEscapeByFastJson.UNI_FEATURES[3] = SerializerFeature.SortField;
        JsonEscapeByFastJson.UNI_FEATURES[4] = SerializerFeature.WriteMapNullValue;
        JsonEscapeByFastJson.UNI_FEATURES[5] = SerializerFeature.BrowserSecure;
        SERIALIZER_FEATURE_MAP = new EnumMap<JsonEscapeType, SerializerFeature[]>(JsonEscapeType.class){
            {
                this.put(JsonEscapeType.ESCAPE_HTML, FEATURES);
                this.put(JsonEscapeType.ESCAPE_UNICODE, UNI_FEATURES);
            }
        };
    }

    private class MyValueFilter
    implements ValueFilter {
        private JsonEscapeType escapeType;

        public MyValueFilter(JsonEscapeType escapeType) {
            this.escapeType = escapeType;
        }

        public Object process(Object source, String name, Object value) {
            if (value instanceof String) {
                return JsonEscapeByFastJson.this.escapeHtml((String)value, this.escapeType);
            }
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!(obj instanceof String)) continue;
                    obj = JsonEscapeByFastJson.this.escapeHtml((String)obj, this.escapeType);
                    list.set(i, obj);
                }
                return list;
            }
            return value;
        }
    }

    private class MyNameFilter
    implements NameFilter {
        private JsonEscapeType escapeType;

        public MyNameFilter(JsonEscapeType escapeType) {
            this.escapeType = escapeType;
        }

        public String process(Object source, String name, Object value) {
            return JsonEscapeByFastJson.this.escapeHtml(name, this.escapeType);
        }
    }
}

