/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.json;

import com.alibaba.security.util.CharMasks;
import com.alibaba.security.xss.json.JsonpFunctionFilter;

public class JsonpFunctionFilterImpl
implements JsonpFunctionFilter {
    private static final int SIZE = 128;
    private static final CharMasks MASKS = new CharMasks(128){
        {
            this.addCharToMasks("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_.");
        }
    };
    private static final boolean[] ALLOW_JSON_KEY_MASKS = MASKS.getMasks();

    public String doFilter(String text) {
        return this.doFilter(text, 2048, true);
    }

    public String doFilter(String text, int maxLength, boolean prefix) {
        return this.innerDoFilter(text, maxLength, prefix, "/**/");
    }

    private String innerDoFilter(String text, int maxInputLength, boolean prefix, String prefixStr) {
        if (text == null) {
            return null;
        }
        if (maxInputLength <= 0) {
            maxInputLength = 2048;
        }
        if (maxInputLength > 0 && text.length() > maxInputLength) {
            text = text.substring(0, maxInputLength);
        }
        StringBuilder sb = new StringBuilder();
        if (prefix) {
            sb.append(prefixStr);
        }
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '\u0000' && c < '\u0080' && ALLOW_JSON_KEY_MASKS[c]) continue;
            if (lastPos != i) {
                sb.append(text.substring(lastPos, i));
            }
            lastPos = i + 1;
        }
        return sb.append(text.substring(lastPos)).toString();
    }
}

