/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.json;

import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.ClassUtils;
import com.alibaba.security.xss.json.JsonEscapeType;
import com.alibaba.security.xss.json.compatible.FastJsonEscape;
import com.alibaba.security.xss.json.compatible.JsonEscapeByFastJson;
import com.alibaba.security.xss.json.compatible.JsonEscapeByOriginFastJson;

public class JsonEscapeCompatibleTool {
    private static final String FAST_JSON_CLASS_PATH = "com.alibaba.securitysdk.fastjson.JSON";
    private static final String ORIGIN_FAST_JSON_CLASS_PATH = "com.alibaba.fastjson.JSON";
    private static final String FAST_JSON_JSONOBJECT_CLASS_PATH = "com.alibaba.securitysdk.fastjson.JSONObject";
    private static final String ORIGIN_FAST_JSON_JSONOBJECT_CLASS_PATH = "com.alibaba.fastjson.JSONObject";
    private static final boolean IS_ORIGIN_FAST_JSON = ClassUtils.isPresent("com.alibaba.fastjson.JSON", ClassUtils.getDefaultClassLoader());
    private static final boolean IS_FAST_JSON = ClassUtils.isPresent("com.alibaba.securitysdk.fastjson.JSON", ClassUtils.getDefaultClassLoader());
    private static Class<?> JSONOBJECT_CLASS_PATH = null;
    private static final FastJsonEscape FAST_JSON_ESCAPE;

    public static String escape(String text, JsonEscapeType escapeType) {
        return FAST_JSON_ESCAPE == null ? null : FAST_JSON_ESCAPE.escape(text, escapeType);
    }

    private static FastJsonEscape createFastJsonEscape() {
        if (IS_ORIGIN_FAST_JSON) {
            return new JsonEscapeByOriginFastJson();
        }
        if (IS_FAST_JSON) {
            return new JsonEscapeByFastJson();
        }
        throw new RuntimeException("Fatal error: cannot find the FastJson objects.");
    }

    public static String escape(Object jsonObject, JsonEscapeType escapeType) {
        if (jsonObject == null) {
            return null;
        }
        if (!JSONOBJECT_CLASS_PATH.isAssignableFrom(jsonObject.getClass())) {
            throw new IllegalArgumentException("The input jsonObject should be assignable from " + JSONOBJECT_CLASS_PATH);
        }
        return FAST_JSON_ESCAPE.escape(jsonObject, escapeType);
    }

    static {
        if (IS_ORIGIN_FAST_JSON) {
            JSONOBJECT_CLASS_PATH = ClassUtils.forNameQuietly(ORIGIN_FAST_JSON_JSONOBJECT_CLASS_PATH, ClassUtils.getDefaultClassLoader());
        } else if (IS_FAST_JSON) {
            JSONOBJECT_CLASS_PATH = ClassUtils.forNameQuietly(FAST_JSON_JSONOBJECT_CLASS_PATH, ClassUtils.getDefaultClassLoader());
        }
        AssertUtil.assertNotNull(JSONOBJECT_CLASS_PATH, "Json class is not present!");
        FAST_JSON_ESCAPE = JsonEscapeCompatibleTool.createFastJsonEscape();
    }
}

