/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.expiringmap;

import com.alibaba.security.util.AssertUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractDelegatedReadWriteLockedConcurrentMap<K, V, T, M extends Map<K, T>>
implements ConcurrentMap<K, V> {
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected final M entries;

    AbstractDelegatedReadWriteLockedConcurrentMap(M entries) {
        this.entries = entries;
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.entries.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.entries.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        AssertUtil.assertNotNull(key, "key");
        this.writeLock.lock();
        try {
            V v = this.entries.containsKey(key) ? (V)this.putInternal(key, value) : null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        AssertUtil.assertNotNull(map, "map");
        this.writeLock.lock();
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.putInternal(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        return this.putInternal(AssertUtil.notNull(key, "key"), value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.entries.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    abstract V putInternal(K var1, V var2);
}

