/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import com.alibaba.security.net.URI;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UrlUtil {
    private static final char[] STOP_WORDS = new char[]{'/', '?', '#'};

    private UrlUtil() {
    }

    public static Map<String, List<String>> splitQuery(URL url) throws UnsupportedEncodingException {
        return UrlUtil.splitQuery(url.getQuery());
    }

    public static Map<String, List<String>> splitQuery(String queryParams) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = queryParams.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)queryPairs.get(key)).add(value);
        }
        return queryPairs;
    }

    public static String parseUrl(String url, boolean isHost) {
        if (isHost) {
            return url.toLowerCase();
        }
        try {
            return UrlUtil.getHost(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static boolean checkHosts(String host) {
        char[] chs = host.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] >= 'a' && chs[i] <= 'z' || chs[i] >= 'A' && chs[i] <= 'Z' || chs[i] >= '0' && chs[i] <= '9' || chs[i] == '-' || chs[i] == '.' || chs[i] == '_' || chs[i] == ':' || chs[i] == '[' || chs[i] == ']') continue;
            return false;
        }
        return true;
    }

    public static String getHost(String url) throws URISyntaxException {
        if ((url = UrlUtil.getHostFormURL(url)) == null) {
            return null;
        }
        String host = new URI(url).getHost();
        if (host == null) {
            return null;
        }
        return host.toLowerCase();
    }

    public static String getScheme(String url) {
        String scheme;
        block5: {
            if ((url = UrlUtil.getHostFormURL(url)) == null) {
                return null;
            }
            scheme = null;
            try {
                scheme = new URI(url).getScheme();
            }
            catch (Exception URISyntaxException2) {
                if (url.contains("://")) {
                    scheme = url.substring(0, url.indexOf("://"));
                }
                if (!url.startsWith("//")) break block5;
                scheme = null;
            }
        }
        if (scheme == null) {
            return null;
        }
        return scheme.toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getHostFormURL(String url) {
        int idx = url.indexOf("://");
        if (idx == -1) {
            if (!url.startsWith("//")) return url;
            idx = 2;
        } else {
            idx += 3;
        }
        while (idx < url.length() - 1 && url.charAt(idx) == '/') {
            ++idx;
        }
        int off = idx;
        char[] cArray = STOP_WORDS;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            idx = url.indexOf(c, off);
            if (idx != -1) {
                return url.substring(0, idx);
            }
            ++n2;
        }
        return url;
    }

    public static boolean checkAt(String url) {
        int urllen = url.length();
        int fn = url.indexOf(47);
        if (fn == -1) {
            return false;
        }
        if (fn < urllen - 2 && url.charAt(fn) == '/' && url.charAt(fn + 1) == '/') {
            int fr = url.indexOf(47, fn + 2);
            if (fr == -1) {
                int fw = url.indexOf(63, fn + 2);
                if (fw > -1) {
                    String sub1 = url.substring(fn + 2, fw);
                    return sub1.indexOf(64) <= -1;
                }
                String sub1 = url.substring(fn + 2, urllen);
                return sub1.indexOf(64) <= -1;
            }
            String sub1 = url.substring(fn + 2, fr);
            return sub1.indexOf(64) <= -1;
        }
        return false;
    }
}

