/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf.checkcondition;

import com.alibaba.security.url.ssrf.checkcondition.SecurityManagerConnectCheckCondition;
import com.alibaba.security.url.ssrf.policy.CompatibleSsrfCheckerRegister;
import com.alibaba.security.util.expiringmap.ExpiringSet;

public class ExpirationCacheSecurityManagerConnectCheckCondition
implements SecurityManagerConnectCheckCondition {
    private static final String HOST_THECK_POINT = "sun.net.www.http.HttpClient";
    private static final String IP_THECK_POINT = "java.net.Socket";
    private static final ThreadLocal<Boolean> NEED_CHECKING = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return false;
        }
    };
    private final ExpiringSet<String> EXPIRING_SET;

    ExpirationCacheSecurityManagerConnectCheckCondition(ExpiringSet<String> expiringSet) {
        this.EXPIRING_SET = expiringSet;
    }

    public ExpirationCacheSecurityManagerConnectCheckCondition() {
        this(CompatibleSsrfCheckerRegister.EXPIRING_SET);
    }

    @Override
    public boolean needsCheck(String host, int port, Class[] classContext) {
        String callerClassName = classContext[1].getName();
        if (HOST_THECK_POINT.equals(callerClassName) && this.EXPIRING_SET.contains(host)) {
            NEED_CHECKING.set(true);
        }
        if (IP_THECK_POINT.equals(callerClassName) && NEED_CHECKING.get().booleanValue()) {
            NEED_CHECKING.set(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean isCustomThrowable() {
        return false;
    }
}

