/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf;

import com.alibaba.security.url.SSRFUnsafeConnectionError;
import com.alibaba.security.url.exception.GlobalSSRFThrowableFactory;
import com.alibaba.security.url.ssrf.SSRFCheckerImpl;
import com.alibaba.security.url.ssrf.checkcondition.SecurityManagerConnectCheckCondition;
import com.alibaba.securitysdk.logging.api.SecType;
import com.alibaba.securitysdk.logging.api.factories.LoggerManager;
import com.alibaba.securitysdk.logging.api.loggers.SecurityModifiedLogger;
import java.awt.AWTPermission;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AliSecurityManager
extends SecurityManager {
    private static final Logger LOGGER = Logger.getLogger(AliSecurityManager.class.getName());
    private static final SecurityModifiedLogger SEC_LOGGER = (SecurityModifiedLogger)LoggerManager.getLogger(SecurityModifiedLogger.class);
    static final String LOG_CONNECT_FORMAT = "Connecting: %s";
    static final String LOG_INFO_FORMAT = "Address %s is not allowed to connect!";
    private SecurityManager delegate;
    private final List<SecurityManagerConnectCheckCondition> checkConditions;

    public AliSecurityManager(SecurityManager securityManager, SecurityManagerConnectCheckCondition ... conditions) {
        this.delegate = securityManager;
        this.checkConditions = Collections.unmodifiableList(Arrays.asList(conditions));
    }

    @Override
    public void checkConnect(String host, int port) {
        AliSecurityManager.log(LOG_CONNECT_FORMAT, host);
        if (port == -1) {
            return;
        }
        for (SecurityManagerConnectCheckCondition checkCondition : this.checkConditions) {
            if (!checkCondition.needsCheck(host, port, this.getClassContext())) continue;
            InetAddress address = new InetSocketAddress(host, port).getAddress();
            boolean allowedAddress = SSRFCheckerImpl.isAllowedAddress(address);
            String info = address == null ? host : address.toString();
            SEC_LOGGER.logBoolean(SecType.SSRF, (Object)info, allowedAddress);
            if (allowedAddress) continue;
            AliSecurityManager.log(LOG_INFO_FORMAT, info);
            this.throwsErrorOrRuntimeException(checkCondition, address);
        }
        if (this.delegate != null) {
            this.delegate.checkConnect(host, port);
        }
    }

    private void throwsErrorOrRuntimeException(SecurityManagerConnectCheckCondition checkCondition, InetAddress address) {
        if (checkCondition.isCustomThrowable()) {
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe address", address);
        }
        throw new SSRFUnsafeConnectionError("unsafe address", address);
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.delegate != null) {
            this.delegate.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.delegate != null) {
            this.delegate.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.delegate != null) {
            this.delegate.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.delegate != null) {
            this.delegate.checkMulticast(maddr);
        }
    }

    @Override
    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.delegate != null) {
            this.delegate.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.delegate != null) {
            this.delegate.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.delegate != null) {
            this.delegate.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.delegate != null) {
            AWTPermission ca = new AWTPermission("showWindowWithoutWarningBanner");
            this.delegate.checkPermission(ca);
        }
        return true;
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.delegate != null) {
            this.delegate.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.delegate != null) {
            AWTPermission ca = new AWTPermission("accessClipboard");
            this.delegate.checkPermission(ca);
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.delegate != null) {
            AWTPermission ca = new AWTPermission("accessEventQueue");
            this.delegate.checkPermission(ca);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.delegate != null) {
            this.delegate.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.delegate != null) {
            this.delegate.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.delegate != null) {
            this.delegate.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.delegate != null) {
            RuntimePermission ca = new RuntimePermission("accessDeclaredMembers");
            this.delegate.checkPermission(ca);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.delegate != null) {
            this.delegate.checkSecurityAccess(target);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        if (this.delegate != null) {
            return this.delegate.getThreadGroup();
        }
        return super.getThreadGroup();
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.delegate != null) {
            this.delegate.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.delegate != null) {
            this.delegate.checkPermission(perm, context);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.delegate != null) {
            this.delegate.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.delegate != null) {
            this.delegate.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.delegate != null) {
            this.delegate.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        if (this.delegate != null) {
            this.delegate.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.delegate != null) {
            this.delegate.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.delegate != null) {
            this.delegate.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.delegate != null) {
            this.delegate.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.delegate != null) {
            this.delegate.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.delegate != null) {
            this.delegate.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.delegate != null) {
            this.delegate.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.delegate != null) {
            this.delegate.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.delegate != null) {
            this.delegate.checkDelete(file);
        }
    }

    @Override
    public Object getSecurityContext() {
        if (this.delegate != null) {
            return this.delegate.getSecurityContext();
        }
        return null;
    }

    static void log(String format, InetAddress address) {
        AliSecurityManager.log(format, address.toString());
    }

    static void log(String format, String input) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, String.format(format, input));
        }
    }
}

