/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.sql;

import com.alibaba.security.sql.SqlFilter;
import com.alibaba.security.util.CharMasks;

public class SqlFilterImpl
implements SqlFilter {
    private static final int SIZE = 128;
    private static final CharMasks MASKS = new CharMasks(128){
        {
            this.addCharToMasks("\\\u0000\n\r'\"");
        }
    };
    private static final boolean[] ESCAPE_CMD_MASKS = MASKS.getMasks();
    private static final char BOUND = '\u001a';
    private static final String ESCAPED_BOUND = "0x1a";
    private static final CharMasks FILTER_TRIM_MASKS = SqlFilterImpl.createCharMasks(false);
    private static final CharMasks FILTER_TRIM_ORDER_BY_MASKS = SqlFilterImpl.createCharMasks(true);

    public String mysqlRealEscapeString(String unescapedString) {
        return SqlFilterImpl.filterStatically(unescapedString);
    }

    private static CharMasks createCharMasks(final boolean forOrderBy) {
        return new CharMasks(128){
            {
                int i;
                super(size);
                for (i = 48; i < 58; ++i) {
                    this.addCharToMasks((char)i);
                }
                for (i = 65; i < 91; ++i) {
                    this.addCharToMasks((char)i);
                }
                for (i = 97; i < 123; ++i) {
                    this.addCharToMasks((char)i);
                }
                this.addCharToMasks("_-.");
                if (forOrderBy) {
                    this.addCharToMasks(" ");
                    this.addCharToMasks(",");
                }
            }
        };
    }

    public String trimSql(String sql) {
        return SqlFilterImpl.trimSqlStatically(sql);
    }

    public String trimSql4OrderBy(String sql) {
        return SqlFilterImpl.trimSqlStatically(sql, true);
    }

    static String trimSqlStatically(String columnName) {
        return SqlFilterImpl.trimSqlStatically(columnName, false);
    }

    static String trimSqlStatically(String columnName, boolean forOrderBy) {
        if (columnName == null || columnName.isEmpty()) {
            return columnName;
        }
        CharMasks masks = forOrderBy ? FILTER_TRIM_ORDER_BY_MASKS : FILTER_TRIM_MASKS;
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            if ((c < '\u0080' || SqlFilterImpl.isChinese(c)) && (c >= '\u0080' || masks.getMasks()[c])) continue;
            sb.append(columnName.substring(lastPos, i));
            lastPos = i + 1;
        }
        return sb.append(columnName.substring(lastPos)).toString();
    }

    static String filterStatically(String sql) {
        if (sql == null || sql.isEmpty()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c < '\u0080' && ESCAPE_CMD_MASKS[c]) {
                sb.append(sql.substring(lastPos, i));
                sb.append('\\').append(c);
                lastPos = i + 1;
                continue;
            }
            if (c != '\u001a') continue;
            sb.append(sql.substring(lastPos, i)).append(ESCAPED_BOUND);
            lastPos = i + 1;
        }
        return sb.append(sql.substring(lastPos)).toString();
    }

    private static boolean isChinese(char c) {
        return Character.isIdeographic(c) || Character.isSurrogate(c);
    }
}

