/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.resolver;

import com.alibaba.security.resource.ssrf.config.xml.Domain;
import com.alibaba.security.resource.ssrf.config.xml.Domains;
import com.alibaba.security.resource.ssrf.config.xml.Hosts;
import com.alibaba.security.resource.ssrf.config.xml.Ip;
import com.alibaba.security.resource.ssrf.config.xml.Ips;
import com.alibaba.security.resource.ssrf.config.xml.Ipv6;
import com.alibaba.security.resource.ssrf.config.xml.Ssrf;
import com.alibaba.security.resource.ssrf.loader.parser.SsrfXmlParser;
import com.alibaba.security.resource.ssrf.loader.resolver.AbstractSyncSsrfOnceResolver;
import com.alibaba.security.resource.ssrf.loader.resolver.SsrfJsonConfigResolver;
import com.alibaba.security.url.CannotLoadResourcesException;
import com.alibaba.security.url.ssrf.SSRFCheckerImpl;
import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.ResourceUtil;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SsrfXmlConfigResolver
extends AbstractSyncSsrfOnceResolver {
    private static final Logger logger = Logger.getLogger(SsrfJsonConfigResolver.class.getName());

    public SsrfXmlConfigResolver(String resourcePath) {
        super(resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resolve() {
        InputStream inputSteam = ResourceUtil.getResourceInputSteam(this.resourcePath, SSRFCheckerImpl.class);
        AssertUtil.checkState(inputSteam == null && "/com/alibaba/security/url/default-def-ssrf-host.xml".equals(this.resourcePath), (RuntimeException)new CannotLoadResourcesException(this.resourcePath));
        try {
            Ssrf ssrfObject;
            if (inputSteam != null && (ssrfObject = new SsrfXmlParser(inputSteam).parse()) != null) {
                Hosts hosts = ssrfObject.getIntranethosts();
                this.setUpHosts(this.domainList, this.ipStringList, this.ipv6StringList, hosts);
                hosts = ssrfObject.getExcludedhosts();
                this.setUpHosts(this.exDomainList, this.exIpStringList, this.exIpv6StringList, hosts);
                hosts = ssrfObject.getTrustedhosts();
                this.setUpHosts(this.trustedDomainList, this.trustedIpList, null, hosts);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Fail to load the configuration file.", e);
            AssertUtil.checkState("/com/alibaba/security/url/default-def-ssrf-host.xml".equals(this.resourcePath), (RuntimeException)new CannotLoadResourcesException(this.resourcePath, e));
        }
        finally {
            IOUtils.closeQuietly(inputSteam);
        }
    }

    private void setUpHosts(List<Domain> domainList, List<Ip> ipStringList, List<Ipv6> ipv6StringList, Hosts hosts) {
        Ips ips;
        if (hosts == null) {
            return;
        }
        Domains domains = hosts.getDomains();
        if (domains != null && domains.getDomain() != null) {
            domainList.addAll(domains.getDomain());
        }
        if ((ips = hosts.getIps()) != null) {
            List<Ipv6> ipv6List;
            List<Ip> ipList = ips.getIp();
            if (ipList != null && ipStringList != null) {
                ipStringList.addAll(ipList);
            }
            if ((ipv6List = ips.getIpv6()) != null && ipv6StringList != null) {
                ipv6StringList.addAll(ipv6List);
            }
        }
    }
}

