/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.resolver;

import com.alibaba.security.resource.ssrf.config.json.SsrfJsonConfig;
import com.alibaba.security.resource.ssrf.config.xml.Domain;
import com.alibaba.security.resource.ssrf.config.xml.Ip;
import com.alibaba.security.resource.ssrf.config.xml.Ipv6;
import com.alibaba.security.resource.ssrf.config.xml.MatcherType;
import com.alibaba.security.resource.ssrf.loader.parser.SsrfJsonParser;
import com.alibaba.security.resource.ssrf.loader.resolver.AbstractSyncSsrfResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SsrfJsonConfigResolver
extends AbstractSyncSsrfResolver {
    private String path;
    private boolean absoluteFilePath;
    private boolean isObserver;

    public SsrfJsonConfigResolver(String resourcePath) {
        this(resourcePath, null, true, false);
    }

    public SsrfJsonConfigResolver(String resourcePath, String path, boolean absoluteFilePath, boolean isObserver) {
        super(resourcePath);
        this.path = path;
        this.absoluteFilePath = absoluteFilePath;
        this.isObserver = isObserver;
    }

    @Override
    void resolve() {
        SsrfJsonConfig ssrfJsonConfig = (SsrfJsonConfig)new SsrfJsonParser(this.resourcePath, this.path, this.absoluteFilePath).parse();
        if (ssrfJsonConfig != null) {
            SsrfJsonConfig.SsrfBean ssrf;
            SsrfJsonConfig.SsrfBean ssrfBean = ssrf = this.isObserver ? ssrfJsonConfig.getSsrfObserver() : ssrfJsonConfig.getSsrf();
            if (ssrf == null) {
                return;
            }
            SsrfJsonConfig.SsrfBean.HostsBean intranetHosts = ssrf.getIntranethosts();
            SsrfJsonConfig.SsrfBean.HostsBean excludedHosts = ssrf.getExcludedhosts();
            SsrfJsonConfig.SsrfBean.HostsBean trustedhosts = ssrf.getTrustedhosts();
            List<SsrfJsonConfig.SsrfBean.HostsBean.DomainsBean> intranetHostsDomains = intranetHosts.getDomains();
            List<SsrfJsonConfig.SsrfBean.HostsBean.IpsBean> intranetHostsIps = intranetHosts.getIps();
            List<SsrfJsonConfig.SsrfBean.HostsBean.Ipv6sBean> intranetHostsIpv6s = intranetHosts.getIpv6s();
            List<SsrfJsonConfig.SsrfBean.HostsBean.DomainsBean> excludedHostsDomains = excludedHosts.getDomains();
            List<SsrfJsonConfig.SsrfBean.HostsBean.IpsBean> excludedHostsIps = excludedHosts.getIps();
            List<SsrfJsonConfig.SsrfBean.HostsBean.Ipv6sBean> excludedHostsIpv6s = excludedHosts.getIpv6s();
            List<SsrfJsonConfig.SsrfBean.HostsBean.DomainsBean> trustedHostsDomains = trustedhosts == null ? null : trustedhosts.getDomains();
            this.domainList.addAll(this.convertJsonDomainsToPojo(intranetHostsDomains));
            this.exDomainList.addAll(this.convertJsonDomainsToPojo(excludedHostsDomains));
            this.ipStringList.addAll(this.convertJsonIpsToPojo(intranetHostsIps));
            this.ipv6StringList.addAll(this.convertJsonIpv6sToPojo(intranetHostsIpv6s));
            this.exIpStringList.addAll(this.convertJsonIpsToPojo(excludedHostsIps));
            this.exIpv6StringList.addAll(this.convertJsonIpv6sToPojo(excludedHostsIpv6s));
            this.trustedDomainList.addAll(this.convertJsonDomainsToPojo(trustedHostsDomains));
        }
    }

    private List<Domain> convertJsonDomainsToPojo(List<SsrfJsonConfig.SsrfBean.HostsBean.DomainsBean> domainsBeans) {
        if (domainsBeans == null) {
            return Collections.emptyList();
        }
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (SsrfJsonConfig.SsrfBean.HostsBean.DomainsBean domainsBean : domainsBeans) {
            Domain domain = new Domain();
            domain.setValue(domainsBean.getDomain());
            String matcherType = domainsBean.getMatcherType();
            if (matcherType != null) {
                domain.setMatcherType(MatcherType.fromValue(matcherType));
            }
            domains.add(domain);
        }
        return domains;
    }

    private List<Ip> convertJsonIpsToPojo(List<SsrfJsonConfig.SsrfBean.HostsBean.IpsBean> ipsBeans) {
        if (ipsBeans == null) {
            return Collections.emptyList();
        }
        ArrayList<Ip> ips = new ArrayList<Ip>();
        for (SsrfJsonConfig.SsrfBean.HostsBean.IpsBean ipsBean : ipsBeans) {
            Ip ip = new Ip();
            ip.setValue(ipsBean.getIp());
            ips.add(ip);
        }
        return ips;
    }

    private List<Ipv6> convertJsonIpv6sToPojo(List<SsrfJsonConfig.SsrfBean.HostsBean.Ipv6sBean> ipsBeans) {
        if (ipsBeans == null) {
            return Collections.emptyList();
        }
        ArrayList<Ipv6> ipv6s = new ArrayList<Ipv6>();
        for (SsrfJsonConfig.SsrfBean.HostsBean.Ipv6sBean ipv6sBean : ipsBeans) {
            Ipv6 ipv6 = new Ipv6();
            ipv6.setValue(ipv6sBean.getIpv6());
            ipv6s.add(ipv6);
        }
        return ipv6s;
    }
}

