/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.richtext.loader.converter;

import com.alibaba.security.resource.richtext.config.json.RichtextJsonConfig;
import com.alibaba.security.util.PropertyUtil;
import com.alibaba.security.util.StringUtils;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.PolicyException;
import com.alibaba.security.xss.richtext.handler.AttributeProcessHandler;
import com.alibaba.security.xss.richtext.handler.TagProcessHandler;
import com.alibaba.security.xss.richtext.model.Action;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.RestrictAttribute;
import com.alibaba.security.xss.richtext.model.Tag;
import com.alibaba.security.xss.richtext.model.TreeNode;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RichtextJson2PolicyConverter {
    private final RichtextJsonConfig richtextJsonConfig;
    private final Policy policy;

    public RichtextJson2PolicyConverter(RichtextJsonConfig richtextJsonConfig) {
        this.richtextJsonConfig = (RichtextJsonConfig)AssertUtil.notNull((Object)richtextJsonConfig);
        this.policy = Policy.newPolicy();
    }

    public Policy convert() throws PolicyException {
        RichtextJsonConfig.XssBean xss = this.richtextJsonConfig.getXss();
        this.policy.setDirectives(this.resoulveDirectives(xss.getDirectives()));
        Map<String, Pattern> regexps = this.resolveRegexps(xss.getCommonRegexps());
        Map<String, TreeNode> safeDomains = this.resolveSafeDomains(xss.getCommonDomains());
        Map<String, List<String>> blockedDomains = this.resolveBlockedDomains(xss.getCommonBlocks());
        HashMap<String, List<String>> tagAttrNameStart = new HashMap<String, List<String>>();
        Map<String, Map<String, Attribute>> tagAttributes = this.resolveTagAttributes(xss.getTagAttributes(), regexps, safeDomains, blockedDomains, tagAttrNameStart);
        Map<String, Tag> tagRules = this.resolveTagRules(xss.getTagRules());
        for (Tag tag : tagRules.values()) {
            String ref = StringUtils.isBlank(tag.getAttrRef()) ? this.policy.toElemsCase(tag.getName()) : this.policy.toElemsCase(tag.getAttrRef());
            tag.setAllowedAttributes(tagAttributes.get(ref));
            tag.setAllowedAttrNameStart((List)tagAttrNameStart.get(tag.getName()));
        }
        this.policy.setTagRules(tagRules);
        return this.policy;
    }

    private void attachAttributesToTags() {
    }

    private Map<String, Tag> resolveTagRules(RichtextJsonConfig.XssBean.TagrulesBean tagrules) throws PolicyException {
        HashMap<String, Tag> tagRules = new HashMap<String, Tag>();
        List<RichtextJsonConfig.XssBean.TagrulesBean.TagBean> tagList = tagrules.getTag();
        for (RichtextJsonConfig.XssBean.TagrulesBean.TagBean tagBean : tagList) {
            String tagName = this.policy.toElemsCase(tagBean.getName());
            Tag tag = new Tag(tagName);
            tagRules.put(tagName, tag);
            TagProcessHandler defTagHandler = Policy.getDefaultTagHandler().get(tagName.toLowerCase());
            if (defTagHandler != null) {
                tag.setAction(Action.HANDLER);
                tag.setActionHandler(defTagHandler);
            }
            tag.setAttrRef(tagBean.getAttributes());
            Action theAction = Action.getByName(tagBean.getAction());
            if (Policy.getDefaultActionTag().contains(tagName.toLowerCase())) {
                tag.setAction(Action.HANDLER);
                continue;
            }
            if (theAction != null) {
                tag.setAction(theAction);
                String actionClass = tagBean.getActionClass();
                if (StringUtils.isBlank(actionClass)) continue;
                String trimmedActionClass = actionClass.trim();
                Policy.CachedProcessHandlerKey key = new Policy.CachedProcessHandlerKey(trimmedActionClass);
                Map<Policy.CachedProcessHandlerKey, TagProcessHandler> cacheTagProcessHandlerMap = Policy.getCacheTagProcessHandlerMap();
                if (!cacheTagProcessHandlerMap.containsKey(key)) {
                    try {
                        Class<?> handlerClass = Class.forName(trimmedActionClass);
                        cacheTagProcessHandlerMap.put(key, (TagProcessHandler)handlerClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new PolicyException("parse tag handler err: tag = " + tag.getName() + "," + e.getMessage());
                    }
                }
                tag.setActionHandler(cacheTagProcessHandlerMap.get(key));
                continue;
            }
            throw new PolicyException("error action: " + tagBean.getAction());
        }
        return tagRules;
    }

    private Map<String, Map<String, Attribute>> resolveTagAttributes(RichtextJsonConfig.XssBean.TagAttributesBean tagattributes, Map<String, Pattern> regexps, Map<String, TreeNode> domains, Map<String, List<String>> blocks, Map<String, List<String>> nameStarts) throws PolicyException {
        HashMap<String, Map<String, Attribute>> tagAttributes = new HashMap<String, Map<String, Attribute>>();
        List<RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean> attributes = tagattributes.getAttributes();
        for (RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean attribute : attributes) {
            String tagName = attribute.getName();
            List<RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean> attributeList = attribute.getAttribute();
            HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
            tagAttributes.put(tagName, attrs);
            ArrayList<String> tagAttrNameStart = new ArrayList<String>();
            nameStarts.put(tagName, tagAttrNameStart);
            for (RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean attributeBean : attributeList) {
                String nameStart = attributeBean.getNameStart();
                if (nameStart != null && nameStart.trim().length() != 0) {
                    tagAttrNameStart.add(nameStart.trim());
                    continue;
                }
                String attributeName = attributeBean.getName();
                attributeName = this.policy.toAttrsCase(attributeName);
                Attribute attr = new Attribute();
                attr.defaultValue = attributeBean.getDefaultVal();
                attr.name = attributeName;
                String handlerStr = attributeBean.getAttrhandler();
                attr.handler = this.parseHandler(tagName, attributeName, handlerStr);
                if ("style".equals(attributeName.toLowerCase())) {
                    attr.restrictAttribute = RestrictAttribute.STYLE;
                } else if ("background".equals(attributeName.toLowerCase())) {
                    attr.restrictAttribute = RestrictAttribute.BACKGROUND;
                }
                attr.allowedRegExp = this.parseAttributeRegular(attributeBean.getRegexpList(), regexps);
                attr.allowedDomain = this.parseAttributeDomains(attributeBean.getDomainList(), domains);
                attr.blockedDomain = this.parseAttributeBlocks(attributeBean.getBlockList(), blocks);
                attrs.put(attributeName, attr);
            }
        }
        return tagAttributes;
    }

    private AttributeProcessHandler parseHandler(String tagName, String attributeName, String handlerStr) throws PolicyException {
        String defaultKey = tagName + "." + attributeName;
        Map<String, AttributeProcessHandler> defaultAttrHandler = Policy.getDefaultAttrHandler();
        AttributeProcessHandler defaultHandler = defaultAttrHandler.get(defaultKey.toLowerCase());
        AttributeProcessHandler attributeProcessHandler = null;
        if (handlerStr != null && handlerStr.trim().length() != 0) {
            Policy.CachedProcessHandlerKey key = new Policy.CachedProcessHandlerKey(handlerStr);
            Map<Policy.CachedProcessHandlerKey, AttributeProcessHandler> cacheAttrProcessHandlerMap = Policy.getCacheAttrProcessHandlerMap();
            if (!cacheAttrProcessHandlerMap.containsKey(key)) {
                try {
                    Class<?> clazz = Class.forName(handlerStr);
                    cacheAttrProcessHandlerMap.put(key, (AttributeProcessHandler)clazz.newInstance());
                }
                catch (Exception e) {
                    throw new PolicyException("parse attribute handler err: attr=" + tagName + "." + attributeName + "," + e.getMessage());
                }
            }
            attributeProcessHandler = cacheAttrProcessHandlerMap.get(key);
        } else if ("style".equals(attributeName.toLowerCase())) {
            attributeProcessHandler = defaultAttrHandler.get("common.style");
        }
        return attributeProcessHandler == null ? defaultHandler : attributeProcessHandler;
    }

    private List<String> parseAttributeBlocks(RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.BlocklistBean blocklistBean, Map<String, List<String>> blocks) throws PolicyException {
        if (blocklistBean == null || blocklistBean.getBlocks() == null || blocklistBean.getBlocks().isEmpty()) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        List<RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.BlocklistBean.BlocksBean> blocksList = blocklistBean.getBlocks();
        for (RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.BlocklistBean.BlocksBean blocksBean : blocksList) {
            String name = blocksBean.getName();
            if (StringUtils.isBlank(name)) continue;
            if (blocks.get(name) == null) {
                throw new PolicyException("Blocked name [" + name + "] is not in the defined block list.");
            }
            resultList.addAll((Collection<String>)blocks.get(name));
        }
        return resultList;
    }

    private List<TreeNode> parseAttributeDomains(RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.DomainlistBean domainlistBean, Map<String, TreeNode> domains) throws PolicyException {
        if (domainlistBean == null || domainlistBean.getDomains() == null || domainlistBean.getDomains().isEmpty()) {
            return null;
        }
        ArrayList<TreeNode> resultList = new ArrayList<TreeNode>();
        List<RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.DomainlistBean.DomainsBean> domainsList = domainlistBean.getDomains();
        for (RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.DomainlistBean.DomainsBean domainsBean : domainsList) {
            String name = domainsBean.getName();
            if (StringUtils.isBlank(name)) continue;
            if (domains.get(name) == null) {
                throw new PolicyException("Domain name [" + name + "] is not in the defined domain list.");
            }
            resultList.add(domains.get(name));
        }
        return resultList;
    }

    private Map<String, Pattern> parseAttributeRegular(RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.RegexplistBean regexplist, Map<String, Pattern> regexps) {
        HashMap<String, Pattern> regMap = new HashMap<String, Pattern>();
        if (regexplist != null && regexplist.getRegexp() != null) {
            List<RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.RegexplistBean.RegexpBean> regexpList = regexplist.getRegexp();
            for (RichtextJsonConfig.XssBean.TagAttributesBean.AttributesBean.AttributeBean.RegexplistBean.RegexpBean regexp : regexpList) {
                String name = regexp.getName();
                String value = regexp.getValue();
                if (!StringUtils.isBlank(name)) {
                    regMap.put(name, regexps.get(value));
                    continue;
                }
                if (StringUtils.isBlank(value) || regMap.containsKey(value)) continue;
                Pattern pattern = Pattern.compile(value, 2);
                regMap.put(name, pattern);
            }
        }
        return regMap;
    }

    private Map<String, List<String>> resolveBlockedDomains(RichtextJsonConfig.XssBean.CommonblocksBean commonblocks) {
        if (commonblocks == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> blocks = new HashMap<String, List<String>>();
        List<RichtextJsonConfig.XssBean.CommonblocksBean.BlockeddomainsBean> blockeddomains = commonblocks.getBlockeddomains();
        for (RichtextJsonConfig.XssBean.CommonblocksBean.BlockeddomainsBean blockeddomain : blockeddomains) {
            String name = blockeddomain.getName();
            List<RichtextJsonConfig.XssBean.CommonblocksBean.BlockeddomainsBean.DomainBeanX> domainList = blockeddomain.getDomain();
            ArrayList<String> list = new ArrayList<String>();
            for (RichtextJsonConfig.XssBean.CommonblocksBean.BlockeddomainsBean.DomainBeanX domainBeanX : domainList) {
                list.add(domainBeanX.getValue());
            }
            blocks.put(name, list);
        }
        return blocks;
    }

    private Map<String, TreeNode> resolveSafeDomains(RichtextJsonConfig.XssBean.CommondomainsBean commondomains) {
        if (commondomains == null) {
            return Collections.emptyMap();
        }
        HashMap<String, TreeNode> domains = new HashMap<String, TreeNode>();
        List<RichtextJsonConfig.XssBean.CommondomainsBean.SafedomainsBean> safedomains = commondomains.getSafedomains();
        for (RichtextJsonConfig.XssBean.CommondomainsBean.SafedomainsBean safedomain : safedomains) {
            String name = safedomain.getName();
            List<RichtextJsonConfig.XssBean.CommondomainsBean.SafedomainsBean.DomainBean> domainBeans = safedomain.getDomain();
            TreeNode tree = new TreeNode();
            for (RichtextJsonConfig.XssBean.CommondomainsBean.SafedomainsBean.DomainBean domainBean : domainBeans) {
                String value = domainBean.getValue();
                String prefixPath = domainBean.getPrefixpath();
                String[] protocols = null;
                String pros = domainBean.getProtocol();
                if (pros != null && pros.trim().length() != 0) {
                    protocols = pros.split("\\|");
                }
                tree.insert(value.toCharArray(), protocols, prefixPath);
            }
            domains.put(name, tree);
        }
        return domains;
    }

    private Map<String, String> resoulveDirectives(RichtextJsonConfig.XssBean.DirectivesBean directivesBean) {
        this.policy.setMaxInputSize(Integer.parseInt(directivesBean.getMaxInputSize()));
        this.policy.setMaxCssInputSize(Integer.parseInt(directivesBean.getMaxCssInputSize()));
        this.policy.setEnableStyleScan(Boolean.parseBoolean(directivesBean.getEnableStyleScan()));
        this.policy.setRemoveComment(Boolean.parseBoolean(directivesBean.getRemoveComment()));
        this.policy.setAttrsLower(Boolean.parseBoolean(directivesBean.getAttrsLower()));
        this.policy.setElemsLower(Boolean.parseBoolean(directivesBean.getElemsLower()));
        this.policy.setUsePurifier(Boolean.parseBoolean(directivesBean.getUsePurifier()));
        this.policy.setUsePreXMLValid(Boolean.parseBoolean(directivesBean.getUsePreXMLValid()));
        this.policy.setUsePreXMLValid(Boolean.parseBoolean(directivesBean.getStrictUrlCheck()));
        this.policy.setEnableNamespace(PropertyUtil.toBollean(directivesBean.getEnableStyleScan(), true));
        this.policy.setRemoveAttrIfEmpty(PropertyUtil.toBollean(directivesBean.getRemoveAttrIfEmpty(), true));
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("maxInputSize", directivesBean.getMaxInputSize());
        directives.put("maxCssInputSize", directivesBean.getMaxCssInputSize());
        directives.put("enableStyleScan", directivesBean.getEnableStyleScan());
        directives.put("removeComment", directivesBean.getRemoveComment());
        directives.put("attrsLower", directivesBean.getAttrsLower());
        directives.put("elemsLower", directivesBean.getElemsLower());
        directives.put("usePurifier", directivesBean.getUsePurifier());
        directives.put("usePreXMLValid", directivesBean.getUsePreXMLValid());
        directives.put("enableNamespace", directivesBean.getEnableStyleScan());
        directives.put("simpleanti_url_prefix", directivesBean.getSimpleanti_url_prefix());
        directives.put("removeAttrIfEmpty", directivesBean.getRemoveAttrIfEmpty());
        return directives;
    }

    private Map<String, Pattern> resolveRegexps(RichtextJsonConfig.XssBean.CommonRegexpsBean commonRegexpsBean) {
        HashMap<String, Pattern> regexps = new HashMap<String, Pattern>();
        String allowNetworking = commonRegexpsBean.getAllowNetworking();
        String allowScriptAccess = commonRegexpsBean.getAllowScriptAccess();
        String commonOffsiteURL = commonRegexpsBean.getCommonOffsiteURL();
        String offsiteURL = commonRegexpsBean.getOffsiteURL();
        String pathAndOffsiteURL = commonRegexpsBean.getPathAndOffsiteURL();
        regexps.put("allowNetworking", Pattern.compile(allowNetworking, 2));
        regexps.put("allowScriptAccess", Pattern.compile(allowScriptAccess, 2));
        regexps.put("commonOffsiteURL", Pattern.compile(commonOffsiteURL, 2));
        regexps.put("offsiteURL", Pattern.compile(offsiteURL, 2));
        regexps.put("pathAndOffsiteURL", Pattern.compile(pathAndOffsiteURL, 2));
        return regexps;
    }
}

