/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.richtext.loader;

import com.alibaba.security.util.PropertyUtil;
import com.alibaba.security.util.StringUtils;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.PolicyException;
import com.alibaba.security.xss.richtext.handler.AttributeProcessHandler;
import com.alibaba.security.xss.richtext.handler.PolicyAdvice;
import com.alibaba.security.xss.richtext.handler.TagProcessHandler;
import com.alibaba.security.xss.richtext.model.Action;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.RestrictAttribute;
import com.alibaba.security.xss.richtext.model.Tag;
import com.alibaba.security.xss.richtext.model.TreeNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RichtextXmlPolicyLoader {
    private final Policy policy = Policy.newPolicy();
    private final InputStream inputStream;

    public RichtextXmlPolicyLoader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Policy load() throws ParserConfigurationException, SAXException, IOException, PolicyException {
        if (this.inputStream == null) {
            throw new PolicyException("The given InputStream is null");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(this.inputStream);
        Element root = dom.getDocumentElement();
        Element directiveListNode = (Element)root.getElementsByTagName("directives").item(0);
        this.policy.setDirectives(this.parseDirectives(directiveListNode));
        Element regexpsListNode = (Element)root.getElementsByTagName("common-regexps").item(0);
        Map<String, Pattern> regexps = this.parseRegexps(regexpsListNode);
        Element domainsListNode = (Element)root.getElementsByTagName("common-domains").item(0);
        Map<String, TreeNode> domains = this.parseDomains(domainsListNode);
        Element blocksListNode = (Element)root.getElementsByTagName("common-blocks").item(0);
        Map<String, List<String>> blocks = this.parseBlocks(blocksListNode);
        Element tagAttributesListNode = (Element)root.getElementsByTagName("tag-attributes").item(0);
        HashMap<String, List<String>> tagAttrNameStart = new HashMap<String, List<String>>();
        Map<String, Map<String, Attribute>> tagAttributes = this.parseTagAttributes(tagAttributesListNode, regexps, domains, blocks, tagAttrNameStart);
        Element tagRulesListNode = (Element)root.getElementsByTagName("tag-rules").item(0);
        Map<String, Tag> tagRules = this.parseTagRules(tagRulesListNode);
        this.policy.setTagRules(tagRules);
        Collection<Tag> tagSet = tagRules.values();
        for (Tag tag : tagSet) {
            String ref = tag.getAttrRef();
            if (StringUtils.isBlank(ref)) {
                ref = tag.getName();
            }
            ref = this.policy.toElemsCase(ref);
            tag.setAllowedAttributes(tagAttributes.get(ref));
            tag.setAllowedAttrNameStart((List)tagAttrNameStart.get(tag.getName()));
        }
        return this.policy;
    }

    private Map<String, String> parseDirectives(Element root) {
        HashMap<String, String> directives = new HashMap<String, String>();
        NodeList directiveNodes = root.getElementsByTagName("directive");
        for (int i = 0; i < directiveNodes.getLength(); ++i) {
            Element element = (Element)directiveNodes.item(i);
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            directives.put(name, value);
        }
        this.policy.setMaxInputSize(Integer.parseInt((String)directives.get("maxInputSize")));
        this.policy.setMaxCssInputSize(Integer.parseInt((String)directives.get("maxCssInputSize")));
        this.policy.setEnableStyleScan(Boolean.parseBoolean((String)directives.get("enableStyleScan")));
        this.policy.setRemoveComment(Boolean.parseBoolean((String)directives.get("removeComment")));
        this.policy.setAttrsLower(Boolean.parseBoolean((String)directives.get("attrsLower")));
        this.policy.setElemsLower(Boolean.parseBoolean((String)directives.get("elemsLower")));
        this.policy.setUsePurifier(Boolean.parseBoolean((String)directives.get("usePurifier")));
        this.policy.setUsePreXMLValid(Boolean.parseBoolean((String)directives.get("usePreXMLValid")));
        this.policy.setStrictUrlCheck(Boolean.parseBoolean((String)directives.get("strictUrlCheck")));
        this.policy.setEnableNamespace(PropertyUtil.toBollean((String)directives.get("enableNamespace"), true));
        this.policy.setRemoveAttrIfEmpty(PropertyUtil.toBollean((String)directives.get("removeAttrIfEmpty"), true));
        return directives;
    }

    private Map<String, Pattern> parseRegexps(Element root) throws PolicyException {
        HashMap<String, Pattern> regexps = new HashMap<String, Pattern>();
        NodeList regNodes = root.getElementsByTagName("regexp");
        for (int i = 0; i < regNodes.getLength(); ++i) {
            Element element = (Element)regNodes.item(i);
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            if (StringUtils.isBlank(name) || StringUtils.isBlank(value)) {
                throw new PolicyException("error regexps name or value");
            }
            Pattern pattern = Pattern.compile(value, 2);
            regexps.put(name, pattern);
        }
        return regexps;
    }

    private Map<String, TreeNode> parseDomains(Element root) throws PolicyException {
        HashMap<String, TreeNode> domains = new HashMap<String, TreeNode>();
        if (root == null) {
            return domains;
        }
        NodeList safedomainsNodes = root.getElementsByTagName("safedomains");
        for (int i = 0; i < safedomainsNodes.getLength(); ++i) {
            Element element = (Element)safedomainsNodes.item(i);
            String name = element.getAttribute("name");
            TreeNode tree = new TreeNode();
            NodeList domainNodes = element.getElementsByTagName("domain");
            for (int j = 0; j < domainNodes.getLength(); ++j) {
                Element dom = (Element)domainNodes.item(j);
                String value = dom.getAttribute("value");
                String prefixpath = dom.getAttribute("prefixpath");
                String[] protocols = null;
                String pros = dom.getAttribute("protocol");
                if (pros != null && pros.trim().length() != 0) {
                    protocols = pros.split("\\|");
                }
                tree.insert(value.toCharArray(), protocols, prefixpath);
            }
            domains.put(name, tree);
        }
        return domains;
    }

    private Map<String, List<String>> parseBlocks(Element root) throws PolicyException {
        HashMap<String, List<String>> blocks = new HashMap<String, List<String>>();
        if (root == null) {
            return blocks;
        }
        NodeList blocksNodes = root.getElementsByTagName("blockeddomains");
        for (int i = 0; i < blocksNodes.getLength(); ++i) {
            Element element = (Element)blocksNodes.item(i);
            String name = element.getAttribute("name");
            ArrayList<String> list = new ArrayList<String>();
            NodeList domainNodes = element.getElementsByTagName("domain");
            for (int j = 0; j < domainNodes.getLength(); ++j) {
                Element dom = (Element)domainNodes.item(j);
                String value = dom.getAttribute("value");
                list.add(value);
            }
            blocks.put(name, list);
        }
        return blocks;
    }

    private Map<String, Tag> parseTagRules(Element root) throws PolicyException {
        HashMap<String, Tag> tagRules = new HashMap<String, Tag>();
        NodeList tagNodes = root.getElementsByTagName("tag");
        for (int i = 0; i < tagNodes.getLength(); ++i) {
            TagProcessHandler defTagHandler;
            Element element = (Element)tagNodes.item(i);
            String tagName = this.policy.toElemsCase(element.getAttribute("name"));
            String action = element.getAttribute("action");
            String actionClass = element.getAttribute("actionClass");
            Tag tag = new Tag(tagName);
            Action theAction = Action.getByName(action);
            if (theAction != null) {
                tag.setAction(theAction);
                if (theAction == Action.HANDLER && actionClass != null && actionClass.trim().length() != 0) {
                    String trimmedActionClass = actionClass.trim();
                    Policy.CachedProcessHandlerKey key = new Policy.CachedProcessHandlerKey(trimmedActionClass);
                    Map<Policy.CachedProcessHandlerKey, TagProcessHandler> cacheTagProcessHandlerMap = Policy.getCacheTagProcessHandlerMap();
                    if (!cacheTagProcessHandlerMap.containsKey(key)) {
                        try {
                            Class<?> handlerClass = Class.forName(trimmedActionClass);
                            TagProcessHandler tagProcessHandler = (TagProcessHandler)handlerClass.newInstance();
                            if (tagProcessHandler instanceof PolicyAdvice) {
                                ((PolicyAdvice)((Object)tagProcessHandler)).setPolicy(this.policy);
                            }
                            cacheTagProcessHandlerMap.put(key, tagProcessHandler);
                        }
                        catch (Exception e) {
                            throw new PolicyException("parse tag handler err: tag = " + tag.getName() + "," + e.getMessage());
                        }
                    }
                    tag.setActionHandler(cacheTagProcessHandlerMap.get(key));
                }
            }
            List<String> defaultActionTag = Policy.getDefaultActionTag();
            if (tag.getAction() == null && defaultActionTag.contains(tagName.toLowerCase())) {
                tag.setAction(Action.HANDLER);
            }
            Map<String, TagProcessHandler> defaultTagHandler = Policy.getDefaultTagHandler();
            if (tag.getActionHandler() == null && tag.getAction() == Action.HANDLER && (defTagHandler = defaultTagHandler.get(tagName.toLowerCase())) != null) {
                tag.setActionHandler(defTagHandler);
            }
            if (tag.getAction() == null) {
                throw new PolicyException("error action: " + action);
            }
            String attributes = element.getAttribute("attributes");
            tag.setAttrRef(attributes);
            tagRules.put(tagName, tag);
        }
        return tagRules;
    }

    private Map<String, Map<String, Attribute>> parseTagAttributes(Element root, Map<String, Pattern> regexps, Map<String, TreeNode> domains, Map<String, List<String>> blocks, Map<String, List<String>> nameStsrt) throws PolicyException {
        HashMap<String, Map<String, Attribute>> tagAttributes = new HashMap<String, Map<String, Attribute>>();
        NodeList attributesNodes = root.getElementsByTagName("attributes");
        for (int i = 0; i < attributesNodes.getLength(); ++i) {
            Element element = (Element)attributesNodes.item(i);
            String tagName = this.policy.toElemsCase(element.getAttribute("name"));
            HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
            ArrayList<String> tagAttrNameStart = new ArrayList<String>();
            tagAttributes.put(tagName, attrs);
            nameStsrt.put(tagName, tagAttrNameStart);
            NodeList attributeNodes = element.getElementsByTagName("attribute");
            for (int j = 0; j < attributeNodes.getLength(); ++j) {
                Element son = (Element)attributeNodes.item(j);
                String attrNameStart = son.getAttribute("nameStart");
                if (attrNameStart != null && attrNameStart.trim().length() != 0) {
                    tagAttrNameStart.add(attrNameStart.trim());
                    continue;
                }
                String attrName = son.getAttribute("name");
                String defaultVal = son.getAttribute("default");
                attrName = this.policy.toAttrsCase(attrName);
                Attribute attr = new Attribute();
                attr.defaultValue = defaultVal;
                attr.name = attrName;
                String defaultKey = tagName + "." + attrName;
                Map<String, AttributeProcessHandler> defaultAttrHandler = Policy.getDefaultAttrHandler();
                AttributeProcessHandler defAttrHandler = defaultAttrHandler.get(defaultKey.toLowerCase());
                if (defAttrHandler != null) {
                    attr.handler = defAttrHandler;
                }
                String handlerStr = son.getAttribute("attrhandler");
                AttributeProcessHandler handler = null;
                if (handlerStr != null && handlerStr.trim().length() != 0) {
                    Policy.CachedProcessHandlerKey key = new Policy.CachedProcessHandlerKey(handlerStr);
                    Map<Policy.CachedProcessHandlerKey, AttributeProcessHandler> cacheAttrProcessHandlerMap = Policy.getCacheAttrProcessHandlerMap();
                    if (!cacheAttrProcessHandlerMap.containsKey(key)) {
                        try {
                            Class<?> clazz = Class.forName(handlerStr);
                            AttributeProcessHandler attributeProcessHandler = (AttributeProcessHandler)clazz.newInstance();
                            if (attributeProcessHandler instanceof PolicyAdvice) {
                                ((PolicyAdvice)((Object)attributeProcessHandler)).setPolicy(this.policy);
                            }
                            cacheAttrProcessHandlerMap.put(key, attributeProcessHandler);
                        }
                        catch (Exception e) {
                            throw new PolicyException("parse attribute handler err: attr=" + tagName + "." + attrName + "," + e.getMessage());
                        }
                    }
                    handler = cacheAttrProcessHandlerMap.get(key);
                } else if ("style".equals(attrName.toLowerCase())) {
                    handler = defaultAttrHandler.get("common.style");
                }
                if (handler != null) {
                    attr.handler = handler;
                }
                if ("style".equals(attrName.toLowerCase())) {
                    attr.restrictAttribute = RestrictAttribute.STYLE;
                } else if ("background".equals(attrName.toLowerCase())) {
                    attr.restrictAttribute = RestrictAttribute.BACKGROUND;
                }
                attr.allowedRegExp = this.parseAttributeRegular(son, regexps);
                attr.allowedDomain = this.parseAttributeDomains(son, domains);
                attr.blockedDomain = this.parseAttributeBlocks(son, blocks);
                attrs.put(attrName, attr);
            }
        }
        return tagAttributes;
    }

    private List<TreeNode> parseAttributeDomains(Element root, Map<String, TreeNode> domains) throws PolicyException {
        ArrayList<TreeNode> domainList = null;
        if (root.hasChildNodes() && root.getElementsByTagName("domain-list").getLength() > 0) {
            domainList = new ArrayList<TreeNode>();
            Element e = (Element)root.getElementsByTagName("domain-list").item(0);
            NodeList domainsNode = e.getElementsByTagName("domains");
            for (int i = 0; i < domainsNode.getLength(); ++i) {
                Element element = (Element)domainsNode.item(i);
                String domainsName = element.getAttribute("name");
                if (StringUtils.isBlank(domainsName)) continue;
                domainList.add(domains.get(domainsName));
            }
        }
        return domainList;
    }

    private List<String> parseAttributeBlocks(Element root, Map<String, List<String>> blocks) throws PolicyException {
        ArrayList blocksList = null;
        if (root.hasChildNodes() && root.getElementsByTagName("block-list").getLength() > 0) {
            blocksList = new ArrayList();
            Element e = (Element)root.getElementsByTagName("block-list").item(0);
            NodeList domainsNode = e.getElementsByTagName("blocks");
            for (int i = 0; i < domainsNode.getLength(); ++i) {
                Element element = (Element)domainsNode.item(i);
                String domainsName = element.getAttribute("name");
                if (StringUtils.isBlank(domainsName)) continue;
                blocksList.addAll(blocks.get(domainsName));
            }
        }
        return blocksList;
    }

    private Map<String, Pattern> parseAttributeRegular(Element root, Map<String, Pattern> regexps) throws PolicyException {
        HashMap<String, Pattern> regMap = null;
        if (root.hasChildNodes() && root.getElementsByTagName("regexp-list").getLength() > 0) {
            regMap = new HashMap<String, Pattern>();
            Element e = (Element)root.getElementsByTagName("regexp-list").item(0);
            NodeList regexprNode = e.getElementsByTagName("regexp");
            for (int i = 0; i < regexprNode.getLength(); ++i) {
                Element element = (Element)regexprNode.item(i);
                String regularName = element.getAttribute("name");
                String regularValue = element.getAttribute("value");
                if (!StringUtils.isBlank(regularName)) {
                    regMap.put(regularName, regexps.get(regularName));
                    continue;
                }
                if (StringUtils.isBlank(regularValue)) continue;
                Pattern pattern = Pattern.compile(regularValue, 2);
                regMap.put(String.valueOf(i), pattern);
            }
        }
        return regMap;
    }
}

