/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.parser.jsonp.regex;

import com.alibaba.security.parser.jsonp.Jsonp;
import com.alibaba.security.parser.jsonp.JsonpParser;
import com.alibaba.security.parser.jsonp.ParseException;
import com.alibaba.security.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexJsonpParser
implements JsonpParser {
    private static final Pattern JSONP_PATTERN = Pattern.compile("^([a-zA-Z_][0-9a-zA-Z_.]*[0-9a-zA-Z_]+)[\\s]*\\((.*)\\)[\\s]*[;]*$");
    private String text;

    public RegexJsonpParser() {
    }

    public RegexJsonpParser(String text) {
        this.text = text;
    }

    @Override
    public Jsonp parse() throws ParseException {
        return this.parse(this.text);
    }

    @Override
    public Jsonp parse(String text) throws ParseException {
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        Jsonp jsonp = null;
        Matcher m = JSONP_PATTERN.matcher(text);
        if (!m.find()) {
            throw new ParseException("Parsing error: the input text is not a jsonp string.");
        }
        jsonp = new Jsonp(m.group(1), m.group(2));
        return jsonp;
    }
}

