/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.name;

import com.alibaba.security.url.CannotLoadResourcesException;
import com.alibaba.security.util.IOUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public enum ChineseFamilyNameLoader {
    instance;

    private List<String> compoundSurnames = new ArrayList<String>();
    private List<String> singleSurnames = new ArrayList<String>();
    private static final String CHINESE_FAMILY_NAME_RESOURCE_PATH = "name/chinese_surname.txt";

    private ChineseFamilyNameLoader() {
        try {
            this.loadNameResource(CHINESE_FAMILY_NAME_RESOURCE_PATH, this.singleSurnames, this.compoundSurnames);
        }
        catch (IOException e) {
            throw new CannotLoadResourcesException(CHINESE_FAMILY_NAME_RESOURCE_PATH, (Exception)e);
        }
    }

    void loadNameResource(String location, List<String> singleSurnames, List<String> compoundSurnames) throws IOException {
        List<String> lines = IOUtils.readLines(location, StandardCharsets.UTF_8.name());
        for (String line : lines) {
            if (line.length() == 1) {
                singleSurnames.add(line);
                continue;
            }
            if (line.length() == 2) {
                compoundSurnames.add(line);
                continue;
            }
            throw new CannotLoadResourcesException("");
        }
    }

    public List<String> getCompoundSurnames() {
        return this.compoundSurnames;
    }

    public List<String> getSingleSurnames() {
        return this.singleSurnames;
    }
}

