/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.model.guest;

import com.alibaba.security.mask.DataType;
import com.alibaba.security.mask.model.guest.AbstractGuestMaskModel;
import com.alibaba.security.mask.name.ChineseName;
import com.alibaba.security.mask.name.NameNormalizer;
import com.alibaba.security.mask.name.SimpleNameNormalizer;
import com.alibaba.security.util.CharUtil;

public class NameGuestMaskModel
extends AbstractGuestMaskModel {
    private NameNormalizer nameNormalizer = new SimpleNameNormalizer();

    @Override
    public DataType getDataType() {
        return DataType.Name;
    }

    @Override
    public String doMask(String input) {
        if (CharUtil.isChineseString(input)) {
            return this.maskChinese(input);
        }
        return "*" + input.substring(1, input.length());
    }

    private String maskChinese(String input) {
        ChineseName chineseName = this.nameNormalizer.normalizeChineseName(input);
        if (chineseName == null) {
            return "";
        }
        String surname = chineseName.getSurname();
        if (surname == null) {
            return "*" + input.substring(1, input.length());
        }
        String masks = new String(new char[surname.length()]).replace("\u0000", "*");
        return masks + chineseName.getFirstName();
    }
}

