/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.model;

import com.alibaba.security.mask.MaskModel;
import com.alibaba.security.mask.exception.CompleteTextNotAllowedException;
import com.alibaba.security.mask.exception.ValidationNotSupportedException;
import com.alibaba.security.util.StringUtils;

public abstract class AbstractMaskModel
implements MaskModel {
    public abstract String doMask(String var1);

    public abstract boolean allowsCompleteText();

    public boolean validate(String input) {
        return false;
    }

    @Override
    public String mask(String input) {
        if (input == null) {
            return null;
        }
        if (StringUtils.isEmpty(input)) {
            return input.trim();
        }
        return this.doMask(input);
    }

    @Override
    public String mask(String input, boolean full) throws CompleteTextNotAllowedException {
        if (input == null) {
            return null;
        }
        if (full) {
            if (this.allowsCompleteText()) {
                return input;
            }
            throw new CompleteTextNotAllowedException();
        }
        return this.mask(input.trim());
    }

    @Override
    public String mask(String input, boolean full, boolean doValidate) throws CompleteTextNotAllowedException, ValidationNotSupportedException {
        if (input == null) {
            return null;
        }
        if (doValidate) {
            if (!this.isValidationSupported()) {
                throw new ValidationNotSupportedException();
            }
            String temp = input.trim();
            if (this.validate(temp)) {
                return this.mask(temp);
            }
            return null;
        }
        if (full) {
            if (this.allowsCompleteText()) {
                return input;
            }
            throw new CompleteTextNotAllowedException();
        }
        return this.mask(input.trim());
    }

    protected boolean isValidationSupported() {
        return false;
    }
}

