/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Op;
import org.apache.hadoop.hive.common.jsonexplain.tez.Printer;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Vertex
implements Comparable<Vertex> {
    public final String name;
    public final TezJsonParser parser;
    public final List<Connection> parentConnections = new ArrayList<Connection>();
    public final List<Vertex> children = new ArrayList<Vertex>();
    public final JSONObject vertexObject;
    public boolean dummy;
    public final List<Op> rootOps = new ArrayList<Op>();
    public final List<Vertex> mergeJoinDummyVertexs = new ArrayList<Vertex>();
    public boolean hasMultiReduceOp = false;
    public String executionMode = "";
    public Map<String, String> tagToInput = new LinkedHashMap<String, String>();
    public String tag;
    public VertexType vertexType;
    public EdgeType edgeType;

    public Vertex(String name, JSONObject vertexObject, TezJsonParser tezJsonParser) {
        this.name = name;
        this.vertexType = this.name != null ? (this.name.contains("Map") ? VertexType.MAP : (this.name.contains("Reduce") ? VertexType.REDUCE : (this.name.contains("Union") ? VertexType.UNION : VertexType.UNKNOWN))) : VertexType.UNKNOWN;
        this.dummy = false;
        this.vertexObject = vertexObject;
        this.parser = tezJsonParser;
    }

    public void addDependency(Connection connection) throws JSONException {
        this.parentConnections.add(connection);
    }

    public void extractOpTree() throws JSONException, JsonParseException, JsonMappingException, IOException, Exception {
        if (this.vertexObject.length() != 0) {
            for (String key : JSONObject.getNames((JSONObject)this.vertexObject)) {
                if (key.equals("Map Operator Tree:")) {
                    this.extractOp(this.vertexObject.getJSONArray(key).getJSONObject(0));
                    continue;
                }
                if (key.equals("Reduce Operator Tree:") || key.equals("Processor Tree:")) {
                    this.extractOp(this.vertexObject.getJSONObject(key));
                    continue;
                }
                if (key.equals("Join:")) {
                    JSONArray array = this.vertexObject.getJSONArray(key);
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject mpOpTree = array.getJSONObject(index);
                        Vertex v = new Vertex(null, mpOpTree, this.parser);
                        v.extractOpTree();
                        v.dummy = true;
                        this.mergeJoinDummyVertexs.add(v);
                    }
                    continue;
                }
                if (key.equals("Merge File Operator")) {
                    JSONObject opTree = this.vertexObject.getJSONObject(key);
                    if (opTree.has("Map Operator Tree:")) {
                        this.extractOp(opTree.getJSONArray("Map Operator Tree:").getJSONObject(0));
                        continue;
                    }
                    throw new Exception("Merge File Operator does not have a Map Operator Tree");
                }
                if (key.equals("Execution mode:")) {
                    this.executionMode = " " + this.vertexObject.getString(key);
                    continue;
                }
                if (key.equals("tagToInput:")) {
                    JSONObject tagToInput = this.vertexObject.getJSONObject(key);
                    for (String tag : JSONObject.getNames((JSONObject)tagToInput)) {
                        this.tagToInput.put(tag, (String)tagToInput.get(tag));
                    }
                    continue;
                }
                if (key.equals("tag:")) {
                    this.tag = this.vertexObject.getString(key);
                    continue;
                }
                throw new Exception("Unsupported operator tree in vertex " + this.name);
            }
        }
    }

    Op extractOp(JSONObject operator) throws JSONException, JsonParseException, JsonMappingException, IOException, Exception {
        String[] names = JSONObject.getNames((JSONObject)operator);
        if (names.length != 1) {
            throw new Exception("Expect only one operator in " + operator.toString());
        }
        String opName = names[0];
        JSONObject attrObj = (JSONObject)operator.get(opName);
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        ArrayList<Op> children = new ArrayList<Op>();
        String id = null;
        String outputVertexName = null;
        for (String attrName : JSONObject.getNames((JSONObject)attrObj)) {
            if (attrName.equals("children")) {
                Object childrenObj = attrObj.get(attrName);
                if (childrenObj instanceof JSONObject) {
                    if (((JSONObject)childrenObj).length() == 0) continue;
                    children.add(this.extractOp((JSONObject)childrenObj));
                    continue;
                }
                if (childrenObj instanceof JSONArray) {
                    if (((JSONArray)childrenObj).length() == 0) continue;
                    JSONArray array = (JSONArray)childrenObj;
                    for (int index = 0; index < array.length(); ++index) {
                        children.add(this.extractOp(array.getJSONObject(index)));
                    }
                    continue;
                }
                throw new Exception("Unsupported operator " + this.name + "'s children operator is neither a jsonobject nor a jsonarray");
            }
            if (attrName.equals("OperatorId:")) {
                id = attrObj.get(attrName).toString();
                continue;
            }
            if (attrName.equals("outputname:")) {
                outputVertexName = attrObj.get(attrName).toString();
                continue;
            }
            if (attrObj.get(attrName).toString().isEmpty()) continue;
            attrs.put(attrName, attrObj.get(attrName).toString());
        }
        Op op = new Op(opName, id, outputVertexName, children, attrs, operator, this, this.parser);
        if (!children.isEmpty()) {
            for (Op child : children) {
                child.parent = op;
            }
        } else {
            this.rootOps.add(op);
        }
        return op;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void print(Printer printer, int indentFlag, String type, Vertex callingVertex) throws JSONException, Exception {
        if (this.parser.printSet.contains(this) && !this.hasMultiReduceOp) {
            if (type != null) {
                printer.println(TezJsonParser.prefixString(indentFlag, "<-") + " Please refer to the previous " + this.name + " [" + type + "]");
                return;
            } else {
                printer.println(TezJsonParser.prefixString(indentFlag, "<-") + " Please refer to the previous " + this.name);
            }
            return;
        }
        this.parser.printSet.add(this);
        if (type != null) {
            printer.println(TezJsonParser.prefixString(indentFlag, "<-") + this.name + " [" + type + "]" + this.executionMode);
        } else if (this.name != null) {
            printer.println(TezJsonParser.prefixString(indentFlag) + this.name + this.executionMode);
        }
        if (this.hasMultiReduceOp && callingVertex.vertexType != VertexType.UNION) {
            Op choose = null;
            for (Op op : this.rootOps) {
                if (!op.outputVertexName.equals(callingVertex.name)) continue;
                choose = op;
            }
            if (choose == null) throw new Exception("Can not find the right reduce output operator for vertex " + this.name);
            choose.print(printer, indentFlag, false);
        } else {
            for (Op op : this.rootOps) {
                if (this.dummy) {
                    op.print(printer, indentFlag, true);
                    continue;
                }
                op.print(printer, indentFlag, false);
            }
        }
        if (this.vertexType != VertexType.UNION) return;
        ++indentFlag;
        for (int index = 0; index < this.parentConnections.size(); ++index) {
            Connection connection = this.parentConnections.get(index);
            connection.from.print(printer, indentFlag, connection.type, this);
        }
    }

    public void checkMultiReduceOperator() {
        if (!this.name.contains("Reduce") || this.rootOps.size() < 2) {
            return;
        }
        for (Op op : this.rootOps) {
            if (op.type == Op.OpType.RS) continue;
            return;
        }
        this.hasMultiReduceOp = true;
    }

    public void setType(String type) {
        switch (type) {
            case "BROADCAST_EDGE": {
                this.edgeType = EdgeType.BROADCAST;
                break;
            }
            case "SIMPLE_EDGE": {
                this.edgeType = EdgeType.SHUFFLE;
                break;
            }
            case "CUSTOM_SIMPLE_EDGE": {
                this.edgeType = EdgeType.PARTITION_ONLY_SHUFFLE;
                break;
            }
            case "CUSTOM_EDGE": {
                this.edgeType = EdgeType.MULTICAST;
                break;
            }
            default: {
                this.edgeType = EdgeType.UNKNOWN;
            }
        }
    }

    @Override
    public int compareTo(Vertex o) {
        return this.name.compareTo(o.name);
    }

    public Op getSingleRSOp() {
        if (this.rootOps.size() == 0) {
            return null;
        }
        Op ret = null;
        for (Op op : this.rootOps) {
            if (op.type != Op.OpType.RS) continue;
            if (ret == null) {
                ret = op;
                continue;
            }
            return null;
        }
        return ret;
    }

    public static enum EdgeType {
        BROADCAST,
        SHUFFLE,
        MULTICAST,
        PARTITION_ONLY_SHUFFLE,
        UNKNOWN;

    }

    public static enum VertexType {
        MAP,
        REDUCE,
        UNION,
        UNKNOWN;

    }
}

