/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dms.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.dms_enterprise20181101.Client;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowGraphRequest;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowGraphResponse;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowGraphResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowRequest;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowResponse;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.type.DmsNodeType;
import com.aliyun.migration.workflow.migration.dms.converter.Dms2WorkflowConverter;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskEdge;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskFlowGraph;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskFlowInfo;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskFlowPackage;
import com.aliyun.migration.workflow.migration.dms.domain.DmsTaskNode;
import com.aliyun.teaopenapi.models.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsHandler {
    private static final Logger log = LoggerFactory.getLogger(DmsHandler.class);
    Client client;
    private Long tenantId;
    private Dms2WorkflowConverter converter = new Dms2WorkflowConverter();

    private Client createClient(String ak, String sk, String endPoint) throws Exception {
        Config config = new Config().setAccessKeyId(ak).setAccessKeySecret(sk).setEndpoint(endPoint);
        return new Client(config);
    }

    public DmsHandler(Datasource schedulerDatasource) {
        Map datasourceProperties = schedulerDatasource.getProperties();
        String ak = (String)datasourceProperties.get("ak");
        String sk = (String)datasourceProperties.get("sk");
        String endpoint = (String)datasourceProperties.get("endpoint");
        try {
            this.client = this.createClient(ak, sk, endpoint);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tenantId = Long.valueOf((String)datasourceProperties.get("tenantId"));
    }

    public Response preCheck() {
        try {
            ListTaskFlowResponse listTaskFlowResponse = this.client.listTaskFlow(new ListTaskFlowRequest().setTid(this.tenantId));
            ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowList taskFlowList = listTaskFlowResponse.getBody().getTaskFlowList();
            if (taskFlowList.getTaskFlow().isEmpty()) {
                return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.find.the.taskflows");
            }
        }
        catch (Exception e) {
            log.error("detect.dms.error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"detect.dms.error");
        }
        return Response.buildSuccess();
    }

    public List<DmsTaskFlowInfo> getAllTaskFlowInfo() throws Exception {
        ListTaskFlowResponse listTaskFlowResponse = this.client.listTaskFlow(new ListTaskFlowRequest().setTid(this.tenantId));
        ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowList taskFlowList = listTaskFlowResponse.getBody().getTaskFlowList();
        List taskFlows = taskFlowList.getTaskFlow();
        ArrayList<DmsTaskFlowInfo> taskFlowInfos = new ArrayList<DmsTaskFlowInfo>();
        for (ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow taskFlowResponseBodyTaskFlowListTaskFlow : taskFlows) {
            DmsTaskFlowInfo taskFlowInfo = new DmsTaskFlowInfo();
            taskFlowInfo.setId(taskFlowResponseBodyTaskFlowListTaskFlow.getId());
            taskFlowInfo.setCreatorId(taskFlowResponseBodyTaskFlowListTaskFlow.getCreatorId());
            taskFlowInfo.setCreatorNickName(taskFlowResponseBodyTaskFlowListTaskFlow.getCreatorNickName());
            taskFlowInfo.setDagOwnerNickName(taskFlowResponseBodyTaskFlowListTaskFlow.getDagOwnerNickName());
            taskFlowInfo.setDeployId(taskFlowResponseBodyTaskFlowListTaskFlow.getDeployId());
            taskFlowInfo.setStatus(taskFlowResponseBodyTaskFlowListTaskFlow.getStatus());
            taskFlowInfo.setLatestInstanceStatus(taskFlowResponseBodyTaskFlowListTaskFlow.getLatestInstanceStatus());
            taskFlowInfo.setLatestInstanceTime(taskFlowResponseBodyTaskFlowListTaskFlow.latestInstanceTime);
            taskFlowInfos.add(taskFlowInfo);
        }
        return taskFlowInfos;
    }

    public DmsTaskFlowGraph getTaskFlowGraph(Long taskFlowId) throws Exception {
        GetTaskFlowGraphResponse getTaskFlowGraphResponse = this.client.getTaskFlowGraph(new GetTaskFlowGraphRequest().setTid(this.tenantId).setDagId(taskFlowId));
        GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraph taskFlowGraph = getTaskFlowGraphResponse.getBody().getTaskFlowGraph();
        List taskFlowGraphNodesNodes = taskFlowGraph.getNodes().getNode();
        List taskFlowGraphEdgesEdges = taskFlowGraph.getEdges().getEdge();
        DmsTaskFlowGraph dmsTaskFlowGraph = new DmsTaskFlowGraph();
        dmsTaskFlowGraph.setTaskFlowId(taskFlowId);
        dmsTaskFlowGraph.setTaskFlowName(taskFlowGraph.getDagName());
        ArrayList<DmsTaskNode> taskNodeList = new ArrayList<DmsTaskNode>();
        ArrayList<DmsTaskEdge> taskEdgeList = new ArrayList<DmsTaskEdge>();
        for (GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphNodesNode taskFlowGraphNodesNode : taskFlowGraphNodesNodes) {
            DmsTaskNode dmsTaskNode = new DmsTaskNode();
            dmsTaskNode.setTaskFlowId(taskFlowGraphNodesNode.getDagId());
            dmsTaskNode.setTaskNodeId(taskFlowGraphNodesNode.getNodeId());
            dmsTaskNode.setTaskNodeName(taskFlowGraphNodesNode.getNodeName());
            dmsTaskNode.setTaskNodeType(DmsNodeType.TypeOf((long)taskFlowGraphNodesNode.getNodeType()));
            dmsTaskNode.setGraphParam(taskFlowGraphNodesNode.getGraphParam());
            dmsTaskNode.setTaskNodeConfig(taskFlowGraphNodesNode.getNodeConfig());
            dmsTaskNode.setTaskNodeContent(taskFlowGraphNodesNode.getNodeContent());
            dmsTaskNode.setTimeVariables(taskFlowGraphNodesNode.getTimeVariables());
            taskNodeList.add(dmsTaskNode);
        }
        for (GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphEdgesEdge taskFlowGraphEdgesEdge : taskFlowGraphEdgesEdges) {
            DmsTaskEdge dmsTaskEdge = new DmsTaskEdge();
            dmsTaskEdge.setId(taskFlowGraphEdgesEdge.getId());
            dmsTaskEdge.setTaskFlowId(taskFlowGraphEdgesEdge.getDagId());
            dmsTaskEdge.setNodeFrom(taskFlowGraphEdgesEdge.getNodeFrom());
            dmsTaskEdge.setNodeEnd(taskFlowGraphEdgesEdge.getNodeEnd());
            taskEdgeList.add(dmsTaskEdge);
        }
        dmsTaskFlowGraph.setTaskNodeList(taskNodeList);
        dmsTaskFlowGraph.setTaskEdgeList(taskEdgeList);
        return dmsTaskFlowGraph;
    }

    public List<DmsTaskFlowGraph> getAllTaskFlowGraph() {
        List<DmsTaskFlowInfo> dmsTaskFlowInfoList;
        ArrayList<DmsTaskFlowGraph> dmsTaskFlowGraphList = new ArrayList<DmsTaskFlowGraph>();
        try {
            dmsTaskFlowInfoList = this.getAllTaskFlowInfo();
        }
        catch (Exception e) {
            log.error("get all dms task graph info error", (Throwable)e);
            return dmsTaskFlowGraphList;
        }
        for (DmsTaskFlowInfo dmsTaskFlowInfo : dmsTaskFlowInfoList) {
            try {
                DmsTaskFlowGraph dmsTaskFlowGraph = this.getTaskFlowGraph(dmsTaskFlowInfo.getId());
                dmsTaskFlowGraphList.add(dmsTaskFlowGraph);
            }
            catch (Exception e) {
                log.error("get dms task graph {} error", (Object)dmsTaskFlowInfo.getId(), (Object)e);
            }
        }
        return dmsTaskFlowGraphList;
    }

    public DmsTaskFlowPackage getDmsTaskFlowPackage() {
        DmsTaskFlowPackage dmsTaskFlowPackage = new DmsTaskFlowPackage();
        dmsTaskFlowPackage.setPackageName(String.valueOf(this.tenantId));
        dmsTaskFlowPackage.setDmsTaskFlowGraphList(this.getAllTaskFlowGraph());
        return dmsTaskFlowPackage;
    }

    public WorkflowProjectPackage read() {
        DmsTaskFlowPackage dmsTaskFlowPackage = this.getDmsTaskFlowPackage();
        return this.converter.convert(dmsTaskFlowPackage);
    }
}

