/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.google.common.collect.Maps;
import java.util.Map;

public enum TaskCodeEnum {
    DATA_SYNC_IMPORT("DATA_SYNC_IMPORT", "\u65b0\u7248\u672c\u539f\u5b50\u5f15\u5165\u4efb\u52a1", "\u65b0\u7248\u672c\u539f\u5b50\u5f15\u5165\u4efb\u52a1"),
    DATA_SYNC_EXPORT("DATA_SYNC_EXPORT", "\u539f\u5b50\u5bfc\u51fa\u4efb\u52a1", "\u539f\u5b50\u5bfc\u51fa\u4efb\u52a1"),
    DATA_IMPORT("DATA_IMPORT", "\u8001\u7248\u672c\u5f15\u5165\u4efb\u52a1", "\u8001\u7248\u672c\u5f15\u5165\u5165\u4efb\u52a1"),
    DATA_EXPORT("DATA_EXPORT", "\u5bfc\u51fa", "\u5bfc\u51fa\u4efb\u52a1"),
    VIRTUAL("VIRTUAL", "\u865a\u4efb\u52a1", "\u865a\u4efb\u52a1"),
    ODPS_PYTHON("ODPS_PYTHON", "ODPS PYTHON\u4efb\u52a1", "ODPS PYTHON\u4efb\u52a1"),
    ODPS_SHELL("ODPS_SHELL", "ODPS SHELL\u4efb\u52a1", "ODPS SHELL\u4efb\u52a1"),
    ODPS_BATCH_SQL("ODPS_BATCH_SQL", "ODPS\u79bb\u7ebf", "ODPS\u79bb\u7ebfSQL\u4efb\u52a1"),
    ODPS_PERL("ODPS_PERL", "ODPS Perl\u4efb\u52a1", "ODPS PERL\u4efb\u52a1"),
    SHELL("SHELL", "Shell\u4efb\u52a1", "Shell\u4efb\u52a1");

    private final String code;
    private static final Map<String, TaskCodeEnum> ALL_VALUES;

    public static TaskCodeEnum fromCode(String code) {
        return ALL_VALUES.get(code);
    }

    public static CodeProgramType toDefaultNodeType(String code) {
        if (TaskCodeEnum.DATA_SYNC_IMPORT.code.equals(code) || TaskCodeEnum.DATA_SYNC_EXPORT.code.equals(code) || TaskCodeEnum.DATA_IMPORT.code.equals(code) || TaskCodeEnum.DATA_EXPORT.code.equals(code)) {
            return CodeProgramType.DI;
        }
        if (TaskCodeEnum.ODPS_BATCH_SQL.code.equalsIgnoreCase(code)) {
            return CodeProgramType.ODPS_SQL;
        }
        if (TaskCodeEnum.ODPS_PYTHON.code.equalsIgnoreCase(code)) {
            return CodeProgramType.PYODPS;
        }
        if (TaskCodeEnum.VIRTUAL.code.equalsIgnoreCase(code)) {
            return CodeProgramType.VIRTUAL;
        }
        if (TaskCodeEnum.ODPS_SHELL.code.equalsIgnoreCase(code)) {
            return CodeProgramType.DIDE_SHELL;
        }
        if (TaskCodeEnum.ODPS_PERL.code.equalsIgnoreCase(code)) {
            return CodeProgramType.ODPS_PERL;
        }
        if (TaskCodeEnum.SHELL.code.equalsIgnoreCase(code)) {
            return CodeProgramType.DIDE_SHELL;
        }
        return null;
    }

    private TaskCodeEnum(String code, String type, String description) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    static {
        ALL_VALUES = Maps.newHashMap();
        for (TaskCodeEnum type : TaskCodeEnum.values()) {
            ALL_VALUES.put(type.getCode(), type);
        }
    }
}

