/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago;

import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DateParser;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.VelocityUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.model.cdp.BaseModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.model.cdp.WriterModel;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class MergeSqlUtil {
    public static String generateMergeSql(boolean isDaily, WriterModel.OdpsWriterModel writerModel, List<String> joinKeys) throws Exception {
        String template;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isDaily) {
            template = "datagoTemplate/merge_template_daily.sql.vm";
            String bizDate = DateParser.parsePartition((String)writerModel.getPt());
            params.put("pt", writerModel.getPtKey()[0]);
            params.put("bizDate", bizDate);
            params.put("bizYesterday", bizDate.replace("}", "-1}"));
        } else {
            template = "datagoTemplate/merge_template_hour.sql.vm";
            params.put("today", DateParser.parsePartition((String)writerModel.getPt().split(",")[0]).replace("{", "[").replace("}", "]"));
            params.put("dayPt", writerModel.getPtKey()[0]);
            params.put("hourPt", writerModel.getPtKey()[1]);
            params.put("bizHour", "@@[HH -1h]");
            params.put("bizLastHour", "@@[HH -2h]");
        }
        List columns = writerModel.getColumns().stream().map(BaseModel.Column::getName).collect(Collectors.toList());
        String tableName = writerModel.getTableName();
        String deltaTableName = writerModel.getDeltaTableName();
        params.put("targetTableName", tableName);
        params.put("targetDeltaTableName", deltaTableName);
        params.put("joinKeys", joinKeys);
        params.put("columns", columns);
        return VelocityUtil.render(template, params);
    }

    public static String generateWhere(Boolean isDaily, WriterModel.OdpsWriterModel writerModel, String incrColumn) throws Exception {
        String template;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isDaily.booleanValue()) {
            template = "datagoTemplate/where_template_daily.sql.vm";
            String bizDate = DateParser.parsePartition((String)writerModel.getPt());
            params.put("bizdate", bizDate);
            params.put("today", bizDate.replace("}", "]").replace("{", "["));
        } else {
            template = "datagoTemplate/where_template_hour.sql.vm";
            String bizDate = DateParser.parsePartition((String)writerModel.getPt().split(",")[0]);
            params.put("today", bizDate.replace("{", "[").replace("}", "]"));
            params.put("bizHour", "@@[HH -1h]");
            params.put("hour", "@@[HH]");
        }
        params.put("incrColumn", incrColumn);
        return VelocityUtil.render(template, params);
    }
}

