/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsfCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DsfCycle.class);
    private static final int MAX_NODE_COUNT = 10000;
    public List<String> nodes = new ArrayList<String>();
    private int[][] adjacencyMatrix = new int[10000][10000];

    private int addNode(String nodeName) {
        if (!this.nodes.contains(nodeName)) {
            if (this.nodes.size() >= 10000) {
                LOGGER.warn("nodes\u8d85\u957f: {}, max node name length: {}", (Object)nodeName, (Object)10000);
                return -1;
            }
            this.nodes.add(nodeName);
            return this.nodes.size() - 1;
        }
        return this.nodes.indexOf(nodeName);
    }

    public void addLine(String startNode, String endNode) {
        int startIndex = this.addNode(startNode);
        int endIndex = this.addNode(endNode);
        if (startIndex >= 0 && endIndex >= 0) {
            this.adjacencyMatrix[startIndex][endIndex] = 1;
        }
    }

    public List<String> findCycle() {
        ArrayList<Integer> trace = new ArrayList<Integer>();
        ArrayList<String> result = new ArrayList<String>();
        if (this.adjacencyMatrix.length > 0) {
            this.findCycle(0, trace, result);
        }
        return result;
    }

    private void findCycle(int v, List<Integer> trace, List<String> result) {
        int j = trace.indexOf(v);
        if (j != -1) {
            StringBuilder sb = new StringBuilder();
            String startNode = this.nodes.get(trace.get(j));
            while (j < trace.size()) {
                sb.append(this.nodes.get(trace.get(j))).append("-");
                ++j;
            }
            result.add("cycle:" + sb.toString() + startNode);
            return;
        }
        trace.add(v);
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.adjacencyMatrix[v][i] != 1) continue;
            this.findCycle(i, trace, result);
        }
        trace.remove(trace.size() - 1);
    }
}

