/*
 * Decompiled with CFR 0.152.
 */
package azkaban.spi;

import java.util.Objects;

public class StorageMetadata {
    private final int projectId;
    private final int version;
    private final String uploader;
    private final byte[] hash;

    public StorageMetadata(int projectId, int version, String uploader, byte[] hash) {
        this.projectId = projectId;
        this.version = version;
        this.uploader = Objects.requireNonNull(uploader);
        this.hash = hash;
    }

    public String toString() {
        return "StorageMetadata{projectId='" + this.projectId + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getUploader() {
        return this.uploader;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageMetadata that = (StorageMetadata)o;
        return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.version, that.version) && Objects.equals(this.uploader, that.uploader);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.version, this.uploader);
    }
}

