/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.pathcmd.BuildHistory;
import com.kitfox.svg.pathcmd.PathCommand;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class MissingGlyph
extends ShapeElement {
    public static final String TAG_NAME = "missingglyph";
    private Shape path = null;
    private int horizAdvX = -1;
    private int vertOriginX = -1;
    private int vertOriginY = -1;
    private int vertAdvY = -1;

    public String getTagName() {
        return TAG_NAME;
    }

    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
    }

    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        String commandList = "";
        if (this.getPres(sty.setName("d"))) {
            commandList = sty.getStringValue();
        }
        if (commandList != null) {
            String fillRule = this.getStyle(sty.setName("fill-rule")) ? sty.getStringValue() : "nonzero";
            PathCommand[] commands = MissingGlyph.parsePathList(commandList);
            GeneralPath buildPath = new GeneralPath(fillRule.equals("evenodd") ? 0 : 1, commands.length);
            BuildHistory hist = new BuildHistory();
            for (int i = 0; i < commands.length; ++i) {
                PathCommand cmd = commands[i];
                cmd.appendPath(buildPath, hist);
            }
            AffineTransform at = new AffineTransform();
            at.scale(1.0, -1.0);
            this.path = at.createTransformedShape(buildPath);
        }
        if (this.getPres(sty.setName("horiz-adv-x"))) {
            this.horizAdvX = sty.getIntValue();
        }
        if (this.getPres(sty.setName("vert-origin-x"))) {
            this.vertOriginX = sty.getIntValue();
        }
        if (this.getPres(sty.setName("vert-origin-y"))) {
            this.vertOriginY = sty.getIntValue();
        }
        if (this.getPres(sty.setName("vert-adv-y"))) {
            this.vertAdvY = sty.getIntValue();
        }
    }

    public Shape getPath() {
        return this.path;
    }

    public void render(Graphics2D g) throws SVGException {
        if (this.path != null) {
            this.renderShape(g, this.path);
        }
        for (SVGElement ele : this.children) {
            if (!(ele instanceof RenderableElement)) continue;
            ((RenderableElement)ele).render(g);
        }
    }

    public int getHorizAdvX() {
        if (this.horizAdvX == -1) {
            this.horizAdvX = ((Font)this.parent).getHorizAdvX();
        }
        return this.horizAdvX;
    }

    public int getVertOriginX() {
        if (this.vertOriginX == -1) {
            this.vertOriginX = this.getHorizAdvX() / 2;
        }
        return this.vertOriginX;
    }

    public int getVertOriginY() {
        if (this.vertOriginY == -1) {
            this.vertOriginY = ((Font)this.parent).getFontFace().getAscent();
        }
        return this.vertOriginY;
    }

    public int getVertAdvY() {
        if (this.vertAdvY == -1) {
            this.vertAdvY = ((Font)this.parent).getFontFace().getUnitsPerEm();
        }
        return this.vertAdvY;
    }

    public Shape getShape() {
        if (this.path != null) {
            return this.shapeToParent(this.path);
        }
        return null;
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.path != null) {
            return this.boundsToParent(this.includeStrokeInBounds(this.path.getBounds2D()));
        }
        return null;
    }

    public boolean updateTime(double curTime) throws SVGException {
        return false;
    }

    public void setPath(Shape path) {
        this.path = path;
    }

    public void setHorizAdvX(int horizAdvX) {
        this.horizAdvX = horizAdvX;
    }

    public void setVertOriginX(int vertOriginX) {
        this.vertOriginX = vertOriginX;
    }

    public void setVertOriginY(int vertOriginY) {
        this.vertOriginY = vertOriginY;
    }

    public void setVertAdvY(int vertAdvY) {
        this.vertAdvY = vertAdvY;
    }
}

