/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.dsv1.handle.AbstractDolphinv1Handler;
import com.aliyun.migration.workflow.migration.dsv1.handle.Dolphinv1FileHandler;
import com.aliyun.migration.workflow.migration.dsv1.handle.Dolphinv1OpenApiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv1Reader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv1Reader.class);
    private AbstractDolphinv1Handler dolphinv1Handler;

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(scheduleDataSource);
        this.dolphinv1Handler = scheduleDataSource.getOperaterType() == Datasource.OperaterType.AUTO ? new Dolphinv1OpenApiHandler(scheduleDataSource, taskContext) : new Dolphinv1FileHandler(scheduleDataSource, taskContext);
        this.dolphinv1Handler.init();
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        return this.dolphinv1Handler.preCheck(scheduleDataSource);
    }

    public WorkflowProjectPackage read() throws Exception {
        WorkflowProjectPackage workflowProjectPackage = this.dolphinv1Handler.read();
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }
}

