/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.hue.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlParseUtil {
    public static void main(String[] args) throws DocumentException {
        String basePath = "/Users/heshijia/work/projects/bigdata-workflow-migration/workflow-migration-reader/xianzhengda-reader/src/main/resources/\u6848\u4f8b\u5bfc\u51fa\u6587\u4ef6/\u5de5\u4f5c\u6d41/11725932356363";
        File baseFile = new File(basePath);
        File[] files = baseFile.listFiles(pathname -> pathname.getName().endsWith(".xml"));
        ArrayList<Wf> wfs = new ArrayList<Wf>();
        for (File file : files) {
            String path = file.getPath();
            Wf wf = XmlParseUtil.ParseWorkflow(path);
            wfs.add(wf);
        }
        HashMap nodeType = new HashMap();
        int wfCount = 0;
        int nodeCount = 0;
        for (Wf wf : wfs) {
            ++wfCount;
            nodeCount += wf.getNodes().size();
            wf.getNodes().forEach(x -> {
                if (!nodeType.containsKey(x.getType())) {
                    nodeType.put(x.getType(), 0);
                }
                nodeType.put(x.getType(), (Integer)nodeType.get(x.getType()) + 1);
            });
        }
        System.out.println("wfCount:" + wfCount + ",nodeCount:" + nodeCount + ",nodeType:" + nodeType);
    }

    public static Wf ParseWorkflow(String path) throws DocumentException {
        File file = new File(path);
        SAXReader reader = new SAXReader();
        Document document = reader.read(file);
        Element root = document.getRootElement();
        Element process = XmlParseUtil.getElementByQName("process", root);
        String wfId = process.attributeValue("id");
        String wfName = process.attributeValue("name");
        Wf wf = new Wf();
        wf.setId(wfId);
        wf.setName(wfName);
        ArrayList<Relation> relations = new ArrayList<Relation>();
        List<Element> elementsByQName = XmlParseUtil.getElementsByQName("sequenceFlow", process);
        elementsByQName.forEach(x -> {
            Relation relation = new Relation();
            relation.setSourceRef(x.attributeValue("sourceRef"));
            relation.setTargetRef(x.attributeValue("targetRef"));
            relations.add(relation);
        });
        wf.setRelations(relations);
        Element startEvent = XmlParseUtil.getElementByQName("startEvent", process);
        ArrayList<WfNode> wfNodes = new ArrayList<WfNode>();
        List<Element> serviceTasks = XmlParseUtil.getElementsByQName("serviceTask", process);
        for (Element serviceTask : serviceTasks) {
            String id = serviceTask.attributeValue("id");
            String name = serviceTask.attributeValue("id");
            WfNode wfNode = new WfNode();
            wfNode.setId(id);
            wfNode.setName(name);
            Element extensionElements = XmlParseUtil.getElementByQName("extensionElements", serviceTask);
            Element typeElement = XmlParseUtil.getElementsByName("type", extensionElements);
            if (Objects.nonNull(typeElement)) {
                Element elementByQName = XmlParseUtil.getElementByQName("expression", typeElement);
                String type = elementByQName.getText();
                wfNode.setType(type);
            }
            Element paramsElement = XmlParseUtil.getElementsByName("params", extensionElements);
            if (Objects.nonNull(typeElement)) {
                Element elementByQName = XmlParseUtil.getElementByQName("expression", paramsElement);
                String params = elementByQName.getText();
                wfNode.setParam(params);
            }
            wfNodes.add(wfNode);
        }
        wf.setNodes(wfNodes);
        return wf;
    }

    private static Element getElementsByName(String qName, Element element) {
        List elements = element.elements();
        return ((List)Optional.ofNullable(elements).orElse(new ArrayList())).stream().filter(x -> x.attributeValue("name").equalsIgnoreCase(qName)).findFirst().orElse(null);
    }

    private static List<Element> getElementsByQName(String qName, Element element) {
        List elements = element.elements();
        return ((List)Optional.ofNullable(elements).orElse(new ArrayList())).stream().filter(x -> x.getQName().getName().equalsIgnoreCase(qName)).toList();
    }

    private static Element getElementByQName(String qName, Element root) {
        List elements = root.elements();
        return ((List)Optional.ofNullable(elements).orElse(new ArrayList())).stream().filter(x -> x.getQName().getName().equalsIgnoreCase(qName)).findFirst().orElse(null);
    }

    static class Wf {
        private String id;
        private String name;
        private List<WfNode> nodes;
        private List<Relation> relations;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<WfNode> getNodes() {
            return this.nodes;
        }

        public List<Relation> getRelations() {
            return this.relations;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNodes(List<WfNode> nodes) {
            this.nodes = nodes;
        }

        public void setRelations(List<Relation> relations) {
            this.relations = relations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wf)) {
                return false;
            }
            Wf other = (Wf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<WfNode> this$nodes = this.getNodes();
            List<WfNode> other$nodes = other.getNodes();
            if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
                return false;
            }
            List<Relation> this$relations = this.getRelations();
            List<Relation> other$relations = other.getRelations();
            return !(this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Wf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<WfNode> $nodes = this.getNodes();
            result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
            List<Relation> $relations = this.getRelations();
            result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
            return result;
        }

        public String toString() {
            return "XmlParseUtil.Wf(id=" + this.getId() + ", name=" + this.getName() + ", nodes=" + this.getNodes() + ", relations=" + this.getRelations() + ")";
        }
    }

    static class WfNode {
        private String id;
        private String name;
        private String type;
        private String param;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getParam() {
            return this.param;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WfNode)) {
                return false;
            }
            WfNode other = (WfNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$param = this.getParam();
            String other$param = other.getParam();
            return !(this$param == null ? other$param != null : !this$param.equals(other$param));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WfNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $param = this.getParam();
            result = result * 59 + ($param == null ? 43 : $param.hashCode());
            return result;
        }

        public String toString() {
            return "XmlParseUtil.WfNode(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", param=" + this.getParam() + ")";
        }
    }

    static class Relation {
        private String sourceRef;
        private String targetRef;

        public String getSourceRef() {
            return this.sourceRef;
        }

        public String getTargetRef() {
            return this.targetRef;
        }

        public void setSourceRef(String sourceRef) {
            this.sourceRef = sourceRef;
        }

        public void setTargetRef(String targetRef) {
            this.targetRef = targetRef;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Relation)) {
                return false;
            }
            Relation other = (Relation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourceRef = this.getSourceRef();
            String other$sourceRef = other.getSourceRef();
            if (this$sourceRef == null ? other$sourceRef != null : !this$sourceRef.equals(other$sourceRef)) {
                return false;
            }
            String this$targetRef = this.getTargetRef();
            String other$targetRef = other.getTargetRef();
            return !(this$targetRef == null ? other$targetRef != null : !this$targetRef.equals(other$targetRef));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Relation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceRef = this.getSourceRef();
            result = result * 59 + ($sourceRef == null ? 43 : $sourceRef.hashCode());
            String $targetRef = this.getTargetRef();
            result = result * 59 + ($targetRef == null ? 43 : $targetRef.hashCode());
            return result;
        }

        public String toString() {
            return "XmlParseUtil.Relation(sourceRef=" + this.getSourceRef() + ", targetRef=" + this.getTargetRef() + ")";
        }
    }
}

