/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.module;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks_public20200518.models.CreateResourceFileAdvanceRequest;
import com.aliyun.dataworks_public20200518.models.CreateResourceFileResponse;
import com.aliyun.dataworks_public20200518.models.ListBusinessResponseBody;
import com.aliyun.dataworks_public20200518.models.ListFilesResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Writer;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.AbstractWriter;
import com.aliyun.migration.workflow.migration.common.config.WriterProjectMappingRuleGroup;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileResponse;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DwConverterFactory;
import com.aliyun.migration.workflow.migration.dw.openapi.tool.DwTaskTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwOpenapiWriter
extends AbstractWriter {
    private static final Logger log = LoggerFactory.getLogger(DwOpenapiWriter.class);
    private DwTaskTool dwTaskTool;
    private Long lastWarningCount = 0L;

    public Writer init(TaskContext taskContext) {
        this.taskContext = taskContext;
        Datasource scheduleDataSource = taskContext.getWriterDatasource();
        Map properties = scheduleDataSource.getProperties();
        String projectIdStr = (String)properties.get("project_id");
        String projectNameStr = (String)properties.get("project_name");
        if (!NumberUtils.isDigits((String)projectIdStr)) {
            log.error("Project id is not number or not found");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PROJECT_CONF_NOT_FOUND);
        }
        String env_ak = System.getenv("LHM_DW_AK");
        String env_sk = System.getenv("LHM_DW_SK");
        if (StringUtils.isNotBlank((CharSequence)env_ak) && StringUtils.isNotBlank((CharSequence)env_sk)) {
            properties.put("ak", env_ak);
            properties.put("sk", env_sk);
        }
        this.dwTaskTool = new DwTaskTool(properties);
        this.workflowProjectPackage = this.getWorkflowProjectPackage(scheduleDataSource, taskContext);
        if (StringUtils.isBlank((CharSequence)taskContext.getBwmConfiguration())) {
            taskContext.setBwmConfiguration("{}");
        }
        log.info("\u5f53\u524d\u914d\u7f6e\u63d0\u4ea4\u89c4\u5219\uff1a{}", (Object)JSONObject.toJSONString((Object)taskContext.getBwmConfiguration(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        WriterProjectMappingRuleGroup writerProjectMappingRuleGroup = taskContext.getBwmConfiguration() == null || !taskContext.getBwmConfiguration().contains("project.mapping") ? new WriterProjectMappingRuleGroup(null, projectIdStr, projectNameStr) : new WriterProjectMappingRuleGroup(JSONObject.parseObject((String)taskContext.getBwmConfiguration()).get("project.mapping").toString(), projectIdStr, projectNameStr);
        this.freshProjectInfoInPackage(writerProjectMappingRuleGroup);
        this.splitWorkflowByTargetProject();
        this.workflowProjectPackage.getWorkflowList().forEach(wf -> wf.getWorkflowNodes().forEach(node -> {
            if (Objects.isNull(node.getTrigger())) {
                if (CollectionUtils.isNotEmpty((Collection)wf.getTriggers())) {
                    node.setTrigger((WorkflowTrigger)wf.getTriggers().get(0));
                } else {
                    log.error("workflow {} {} has no trigger", (Object)wf.getWorkflowId(), (Object)wf.getWorkflowName());
                }
            }
        }));
        this.taskContext.setWorkflowProjectPackage(this.workflowProjectPackage);
        return this;
    }

    private void splitWorkflowByTargetProject() {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        ArrayList newWorkflowList = new ArrayList();
        for (Workflow workflow : workflowList) {
            HashMap<String, Workflow> projectWorkflowMap = new HashMap<String, Workflow>();
            Workflow defaultWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
            defaultWorkflow.setWorkflowNodes(new ArrayList());
            projectWorkflowMap.put(defaultWorkflow.getProjectId(), defaultWorkflow);
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                String targetProjectId = node.getProjectId();
                if (!projectWorkflowMap.containsKey(targetProjectId)) {
                    Workflow newWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
                    newWorkflow.setProjectId(node.getProjectId());
                    newWorkflow.setProjectName(node.getProjectName());
                    newWorkflow.setWorkflowNodes(new ArrayList());
                    projectWorkflowMap.put(targetProjectId, newWorkflow);
                }
                ((Workflow)projectWorkflowMap.get(targetProjectId)).getWorkflowNodes().add(node);
            }
            newWorkflowList.addAll(projectWorkflowMap.values());
        }
        this.workflowProjectPackage.setWorkflowList(newWorkflowList);
    }

    private void freshProjectInfoInPackage(WriterProjectMappingRuleGroup writerProjectMappingRuleGroup) {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        for (Workflow workflow : workflowList) {
            Pair targetProjectInfo = writerProjectMappingRuleGroup.getTargetProjectId4Workflow(workflow);
            workflow.setProjectId((String)targetProjectInfo.getKey());
            workflow.setProjectName((String)targetProjectInfo.getValue());
            this.supplyFileAndFunction(workflow.getFiles(), workflow.getFunctions(), (String)targetProjectInfo.getKey());
            List workflowNodes = workflow.getWorkflowNodes();
            for (WorkflowNode node : workflowNodes) {
                targetProjectInfo = writerProjectMappingRuleGroup.getTargetProjectId4Node(node);
                node.setProjectName((String)targetProjectInfo.getValue());
                node.setProjectId((String)targetProjectInfo.getKey());
                this.supplyFileAndFunction(node.getFiles(), node.getFunctions(), (String)targetProjectInfo.getKey());
                node.setWorkflowName(workflow.getWorkflowName());
                if (Objects.isNull(this.workflowProjectPackage.getFilePath())) {
                    log.warn("not.found.project.prefix.path");
                }
                this.supplyTriggerNode(workflow.getTriggers(), node);
                node.setScriptPathPreFix(this.workflowProjectPackage.getFilePath());
                this.adaptNodeType(node);
            }
        }
    }

    private void supplyTriggerNode(List<WorkflowTrigger> triggers, WorkflowNode workflowNode) {
        if (CollectionUtils.isEmpty(triggers)) {
            return;
        }
        WorkflowTrigger workflowTrigger = triggers.get(0);
        workflowNode.setTrigger(workflowTrigger);
    }

    private void supplyFileAndFunction(List<WorkflowFileResource> fileResources, List<WorkflowFunctionResource> functionResources, String projectIdStr) {
        ((List)Optional.ofNullable(fileResources).orElse(new ArrayList())).forEach(fileResource -> {
            if (!StringUtils.equals((CharSequence)fileResource.getProjectId(), (CharSequence)projectIdStr)) {
                fileResource.setProjectId(projectIdStr);
            }
        });
        ((List)Optional.ofNullable(functionResources).orElse(new ArrayList())).forEach(functionResource -> {
            if (!StringUtils.equals((CharSequence)functionResource.getProjectId(), (CharSequence)projectIdStr)) {
                functionResource.setProjectId(projectIdStr);
            }
        });
    }

    private WorkflowProjectPackage getWorkflowProjectPackage(Datasource scheduleDataSource, TaskContext taskContext) {
        if (Objects.nonNull(taskContext) && Objects.nonNull(taskContext.getWorkflowProjectPackage())) {
            return taskContext.getWorkflowProjectPackage();
        }
        Map properties = scheduleDataSource.getProperties();
        String filePath = (String)properties.get("source-file-path");
        WorkflowProjectPackage workflowProjectPackage = BwmPackageFileOperator.readFile((String)filePath);
        if (Objects.isNull(workflowProjectPackage)) {
            log.error("get.workflowProjectPackage.error");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.WORKFLOW_PACKAGE_NOT_FOUND);
        }
        taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }

    private void packageSlim(WorkflowProjectPackage workflowProjectPackage) {
        if (Objects.isNull(workflowProjectPackage)) {
            return;
        }
        workflowProjectPackage.getWorkflowList().forEach(wf -> wf.setTriggers(null));
    }

    private void adaptNodeType(WorkflowNode node) {
        if (Objects.isNull(node.getNodeType())) {
            log.warn("node type is null when adaptnodeType");
            return;
        }
        if (node.getNodeType().equals("VI")) {
            node.setNodeType(String.valueOf(CodeProgramType.VIRTUAL.getCode()));
        } else if (node.getNodeType().equals("SQL")) {
            node.setNodeType(String.valueOf(CodeProgramType.ODPS_SQL.getCode()));
        } else {
            CodeProgramType codeProgramType = BwmCommonUtil.getCodeType((String)node.getNodeType());
            Optional.ofNullable(codeProgramType).ifPresent(x -> {
                int code = x.getCode();
                node.setNodeType(String.valueOf(code));
            });
        }
    }

    public void close() {
        super.close();
        log.info("\u672c\u6b21\u6d88\u8017Dataworks API\u8bf7\u6c42\u6b21\u6570\u4e3a{}\uff0c\u8bf7\u6ce8\u610fAPI\u65e5\u6d88\u8017\u9650\u5236\u3002", (Object)this.getRequestTimesCount());
    }

    protected void createFolder(String folderPath, String projectId, String workflowName) {
    }

    protected Long getExistedNode(WorkflowNode workflowNode) {
        ListFilesResponseBody.ListFilesResponseBodyDataFiles existedWorkflowNode = this.dwTaskTool.getExistedWorkflowNode(workflowNode);
        if (Objects.isNull(existedWorkflowNode)) {
            return null;
        }
        workflowNode.setTNodeId(existedWorkflowNode.getFileId().toString());
        return existedWorkflowNode.getFileId();
    }

    protected Long existWorkflowId(Workflow workflow) {
        ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness existedBusiness = this.dwTaskTool.getExistedBusiness(workflow);
        if (Objects.isNull(existedBusiness)) {
            log.warn("not found business");
            return 0L;
        }
        workflow.setTWorkflowId(existedBusiness.getBusinessId().toString());
        return existedBusiness.getBusinessId();
    }

    protected Long existResourceFileId(WorkflowFileResource workflowFileResource, String projectId) {
        try {
            Long existedResourceFileId = this.dwTaskTool.getDwClient().getExistedResourceFileId(workflowFileResource.getName(), Long.parseLong(projectId));
            workflowFileResource.setFileId(existedResourceFileId.toString());
            return existedResourceFileId;
        }
        catch (Exception e) {
            log.error("getExistedResourceFileId error", (Throwable)e);
            return -1L;
        }
    }

    protected Long createWorkflowBaseReal(Workflow workflow) throws Exception {
        CustomCreateFileRequest request = new CustomCreateFileRequest();
        request.setActionName("CreateBusiness");
        request.setProjectId(Long.valueOf(Long.parseLong(workflow.getProjectId())));
        request.setProjectIdentifier(workflow.getProjectId());
        request.setBusinessName(workflow.getWorkflowName());
        request.setDescription(workflow.getDescription());
        request.setOwner(workflow.getOwner());
        request.setUseType("NORMAL");
        CustomCreateFileResponse response = this.dwTaskTool.sendRequest(request);
        return response.getBody().getBusinessId();
    }

    protected Object createResourceFileReal(WorkflowFileResource workflowFileResource, String projectId, String workflowName) throws Exception {
        if (Objects.isNull(workflowFileResource)) {
            return -1;
        }
        AbstractDwNodeConverter nodeConverter = DwConverterFactory.buildConvert(workflowFileResource.getFileType(), BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()));
        WorkflowNode tempNode = new WorkflowNode();
        ArrayList<WorkflowFileResource> tempFileList = new ArrayList<WorkflowFileResource>();
        tempFileList.add(workflowFileResource);
        tempNode.setProjectId(projectId);
        tempNode.setWorkflowName(workflowName);
        tempNode.setFiles(tempFileList);
        tempNode.setNodeType(workflowFileResource.getFileType());
        CustomCreateFileRequest request = nodeConverter.convert(tempNode);
        if (Objects.isNull(request)) {
            log.error("request is null");
            return -1;
        }
        if (Objects.isNull(request.resourceFileObject == null)) {
            return -1;
        }
        CreateResourceFileAdvanceRequest advanceRequest = new CreateResourceFileAdvanceRequest();
        advanceRequest.setProjectId(request.projectId);
        advanceRequest.setFileName(request.fileName);
        advanceRequest.setFileType(request.fileType);
        advanceRequest.setFileDescription(request.fileDescription);
        advanceRequest.setFileFolderPath(request.fileFolderPath);
        advanceRequest.setOriginResourceName(request.originResourceName);
        advanceRequest.setResourceFileObject(request.resourceFileObject);
        advanceRequest.setRegisterToCalcEngine(request.registerToCalcEngine);
        CreateResourceFileResponse response = this.dwTaskTool.getDwClient().createResourceFileAdvanced(advanceRequest);
        return response;
    }

    protected void deleteResourceFile(long projectId, long fileId) throws Exception {
        this.dwTaskTool.getDwClient().deleteResourceFile(projectId, fileId);
    }

    protected Object createFunctionReal(WorkflowFunctionResource workflowFunctionResource, String projectId, String workflowName) throws Exception {
        if (Objects.isNull(workflowFunctionResource)) {
            return -1L;
        }
        AbstractDwNodeConverter nodeConverter = DwConverterFactory.buildConvert(workflowFunctionResource.getType(), BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()));
        WorkflowNode tempNode = new WorkflowNode();
        ArrayList<WorkflowFunctionResource> tempFunctionList = new ArrayList<WorkflowFunctionResource>();
        tempFunctionList.add(workflowFunctionResource);
        tempNode.setProjectId(projectId);
        tempNode.setWorkflowName(workflowName);
        tempNode.setFunctions(tempFunctionList);
        CustomCreateFileRequest request = nodeConverter.convert(tempNode);
        if (Objects.isNull(request)) {
            return -1L;
        }
        CustomCreateFileResponse response = this.dwTaskTool.sendRequest(request);
        return (Long)response.getBody().getData();
    }

    protected Long createNodeReal(WorkflowNode workflowNode) throws Exception {
        Long result = -1L;
        if (Objects.isNull(workflowNode)) {
            return -1L;
        }
        AbstractDwNodeConverter nodeConvert = DwConverterFactory.buildConvert(workflowNode.getNodeType(), BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()));
        CustomCreateFileRequest request = nodeConvert.convert(workflowNode);
        CustomCreateFileResponse response = this.dwTaskTool.sendRequest(request);
        String nodeType = workflowNode.getNodeType();
        CodeProgramType nodeTypeByCode = CodeProgramType.getNodeTypeByCode((int)Integer.parseInt(nodeType));
        if (nodeTypeByCode == CodeProgramType.DI) {
            Map data = (Map)response.getBody().getData();
            if (StringUtils.equalsIgnoreCase((CharSequence)"fail", (CharSequence)data.get("Status").toString())) {
                log.error(BwmJsonUtil.toJsonString((Object)data));
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_WRITE_FAILED, (String)data.get("Message").toString());
            }
            result = (Long)data.get("FileId");
        } else {
            result = (Long)response.getBody().getData();
        }
        this.printRequestTimesCount();
        return result;
    }

    protected Long updateNodeReal(WorkflowNode workflowNode, String fieldId) throws Exception {
        Long result = -1L;
        if (Objects.isNull(workflowNode)) {
            return result;
        }
        AbstractDwNodeConverter nodeConvert = DwConverterFactory.buildConvert(workflowNode.getNodeType(), BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()));
        CustomCreateFileRequest request = nodeConvert.convert(workflowNode);
        request.setFileId(Long.valueOf(Long.parseLong(fieldId)));
        request.setActionName("UpdateFile");
        CustomCreateFileResponse response = this.dwTaskTool.sendRequest(request);
        String nodeType = workflowNode.getNodeType();
        CodeProgramType nodeTypeByCode = CodeProgramType.getNodeTypeByCode((int)Integer.parseInt(nodeType));
        if (nodeTypeByCode == CodeProgramType.DI) {
            request.setActionName("UpdateDISyncTask");
            response = this.dwTaskTool.sendRequest(request);
        }
        this.printRequestTimesCount();
        if (response.getBody().getSuccess().booleanValue()) {
            return 1L;
        }
        return 0L;
    }

    protected void submitReal(String projectId, String fieldId) {
        try {
            this.dwTaskTool.submitTask(Long.parseLong(projectId), Long.parseLong(fieldId));
        }
        catch (Exception e) {
            log.error("submit task error fieldId {}", (Object)fieldId, (Object)e);
        }
    }

    public Long getRequestTimesCount() {
        return this.dwTaskTool.getRequestTimesCount();
    }

    public void printRequestTimesCount() {
        Long time = this.getRequestTimesCount();
        if (time - this.lastWarningCount >= 10L) {
            if (time < 9000L) {
                log.info("API REQUEST COUNTER: {}", (Object)time);
            } else if (time == 9000L) {
                log.warn("API REQUEST COUNTER: {}, DataWorks\u4e13\u4e1a\u7248\u65e5\u4e0a\u965010000\uff0c\u8bf7\u6ce8\u610f\u6682\u505c\uff0c\u6682\u505c\u6307\u4ee4kill -STOP <\u8fdb\u7a0bid>\uff0c\u6062\u590d\u6307\u4ee4kill -CONT <\u8fdb\u7a0bid>", (Object)time);
            } else if (time < 9750L) {
                log.warn("API REQUEST COUNTER: {} \uff08DataWorks\u4e13\u4e1a\u7248\u65e5\u4e0a\u965010000\uff09", (Object)time);
            } else {
                log.error("API REQUEST COUNTER: {}, DataWorks\u4e13\u4e1a\u7248\u65e5\u4e0a\u965010000\uff0c\u5efa\u8bae\u6682\u505c\u5199\u5165\uff01\u6682\u505c\u6307\u4ee4kill -STOP <\u8fdb\u7a0bid>\uff0c\u6062\u590d\u6307\u4ee4kill -CONT <\u8fdb\u7a0bid>", (Object)time);
            }
            this.lastWarningCount = time;
        }
    }
}

