/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.common.DwCommonUtil;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DefaultConverter;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODPSMRConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(ODPSMRConverter.class);
    private static final String ODPS_FILE_FOLDER_FORMAT = "\u4e1a\u52a1\u6d41\u7a0b/%s/MaxCompute";

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        DefaultConverter defaultConverter = new DefaultConverter(this.taskContextConf);
        CustomCreateFileRequest customCreateFileRequest = defaultConverter.convert(workflowNode);
        customCreateFileRequest.setFileFolderPath(String.format(ODPS_FILE_FOLDER_FORMAT, workflowNode.getWorkflowName()));
        customCreateFileRequest.setNodeType(DwCommonUtil.getType(workflowNode.getNodeType()));
        String prefixPath = workflowNode.getScriptPathPreFix();
        customCreateFileRequest.setPrefixPath(prefixPath);
        if (Objects.nonNull(this.taskContextConf)) {
            Boolean autoParse = this.taskContextConf.getBool("autoParse", Boolean.FALSE.booleanValue());
            customCreateFileRequest.setAutoParsing(autoParse);
        }
        customCreateFileRequest.setProjectId(Long.valueOf(Long.parseLong(workflowNode.getProjectId())));
        workflowNode.setScriptPath(StringUtils.trim((String)workflowNode.getScriptPath()));
        customCreateFileRequest.setFileName(workflowNode.getNodeName());
        customCreateFileRequest.setContent(workflowNode.getScript());
        this.setInputList(workflowNode.getProjectName(), workflowNode, customCreateFileRequest);
        return customCreateFileRequest;
    }
}

