/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class AbstractDwNodeConverter {
    protected String pre_node_format = "%s_out";
    protected String root_format = "%s_root";
    protected BwmConfiguration taskContextConf;

    public void setConf(BwmConfiguration taskContextConf) {
        this.taskContextConf = Objects.isNull(taskContextConf) ? BwmConfiguration.newDefault() : (Objects.nonNull(taskContextConf.get("conf")) ? taskContextConf.getConfiguration("conf") : taskContextConf);
    }

    protected void setInputList(String projectName, WorkflowNode workflowNode, CustomCreateFileRequest request) {
        if (CollectionUtils.isEmpty((Collection)workflowNode.getParentTargetIds())) {
            request.setInputList(String.format(this.root_format, projectName));
        } else {
            ArrayList<String> parentFileList = new ArrayList<String>();
            for (String dwParentId : workflowNode.getParentTargetIds()) {
                if (StringUtils.isBlank((CharSequence)dwParentId)) continue;
                String parentFileMsg = String.format(this.pre_node_format, dwParentId);
                parentFileList.add(parentFileMsg);
            }
            request.setInputList(String.join((CharSequence)",", parentFileList));
        }
    }

    public abstract CustomCreateFileRequest convert(WorkflowNode var1);
}

