/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.bwm.xls.reader.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageXlsReportFileOperator;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmXlsReader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(BwmXlsReader.class);

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        return null;
    }

    public WorkflowProjectPackage read() throws Exception {
        Datasource readerDatasource = this.taskContext.getReaderDatasource();
        Map readerDatasourceProperties = readerDatasource.getProperties();
        String filePath = (String)readerDatasourceProperties.get("source-file-path");
        this.taskContext.setTargetFilePackage((String)readerDatasourceProperties.get("export-file-path"));
        if (StringUtils.isBlank((CharSequence)filePath) || !new File(filePath).exists() || !filePath.endsWith(".xls")) {
            log.warn("not found xls");
            return null;
        }
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        workflowProjectPackage.setWorkflowList(new ArrayList());
        BwmPackageXlsReportFileOperator.getChangeFromStatisticXls((WorkflowProjectPackage)workflowProjectPackage, (File)new File(filePath));
        workflowProjectPackage.setWorkflowProject(new WorkflowProject());
        workflowProjectPackage.getWorkflowProject().setName((String)readerDatasourceProperties.get("project"));
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        this.taskContext.setTargetWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }
}

