/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource.mapping;

import com.aliyun.migration.teleport.common.utils.resource.mapping.MappingRule;
import com.aliyun.migration.teleport.common.utils.resource.mapping.ResourceMapping;
import org.apache.commons.lang3.StringUtils;

public class DbMapping
implements ResourceMapping {
    protected String rule;

    public DbMapping(String rule) {
        this.rule = rule;
    }

    @Override
    public String map(String dbName) {
        if (StringUtils.isBlank((CharSequence)dbName)) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)this.rule)) {
            return dbName;
        }
        MappingRule mappingRule = MappingRule.parse(this.rule.trim());
        if (mappingRule == null) {
            return dbName;
        }
        switch (mappingRule.getType()) {
            case REPLACE: {
                return dbName.replace(mappingRule.getKeyword(), mappingRule.getReplace());
            }
            case PREFIX: {
                return mappingRule.getKeyword() + dbName;
            }
            case SUFFIX: {
                return dbName + mappingRule.getKeyword();
            }
            case NONE: {
                return mappingRule.getReplace();
            }
        }
        return dbName;
    }
}

