/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource;

import com.aliyun.migration.teleport.common.dto.meta.condition.MetaDiscoveryCondition;
import com.aliyun.migration.teleport.common.dto.migration.enums.MatchType;
import com.aliyun.migration.teleport.common.element.meta.dataset.QualifiedName;
import com.aliyun.migration.teleport.common.utils.resource.matcher.CatalogMatcher;
import com.aliyun.migration.teleport.common.utils.resource.matcher.DbMatcher;
import com.aliyun.migration.teleport.common.utils.resource.matcher.PartitionMatcher;
import com.aliyun.migration.teleport.common.utils.resource.matcher.TableMatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class MetaDiscoveryFilter {
    protected List<MatcherChain> filters = new ArrayList<MatcherChain>();

    public MetaDiscoveryFilter(List<MetaDiscoveryCondition> conditions) {
        if (!CollectionUtils.isEmpty(conditions)) {
            for (MetaDiscoveryCondition condition : conditions) {
                this.filters.add(new MatcherChain(condition));
            }
        } else {
            this.filters.add(new MatcherChain(null));
        }
    }

    public boolean isMatch(QualifiedName qualifiedName) {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (MatcherChain chain : this.filters) {
            if (!chain.isMatch(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public List<MatcherChain> getFilters() {
        return this.filters;
    }

    public static class MatcherChain {
        private static final int MAPPING_PARTS = 3;
        private MetaDiscoveryCondition condition;
        private MatchType matchType;
        private CatalogMatcher catalogMatcher;
        private DbMatcher dbMatcher;
        private TableMatcher tableMatcher;
        private PartitionMatcher partitionMatcher;

        public MatcherChain(MetaDiscoveryCondition condition) {
            if (condition == null) {
                this.matchType = MatchType.WHITE_LIST;
                this.catalogMatcher = new CatalogMatcher("");
                this.dbMatcher = new DbMatcher("");
                this.tableMatcher = new TableMatcher("");
                this.partitionMatcher = new PartitionMatcher("");
                this.condition = new MetaDiscoveryCondition(MatchType.WHITE_LIST, "", "", "", "");
            } else {
                this.matchType = condition.getType();
                this.catalogMatcher = new CatalogMatcher(condition.getCatalogName());
                this.dbMatcher = new DbMatcher(condition.getSchemaName());
                this.tableMatcher = new TableMatcher(condition.getTableNamePattern());
                this.partitionMatcher = new PartitionMatcher(condition.getPartitionFilter());
                this.condition = condition;
            }
        }

        public boolean isMatch(QualifiedName qualifiedName) {
            if (this.condition == null) {
                return false;
            }
            String catalogName = qualifiedName.getCatalogName();
            String schemaName = qualifiedName.getSchemaName();
            String tableName = qualifiedName.getTableName();
            String partitionName = qualifiedName.getPartitionName();
            boolean catalogFlag = StringUtils.isBlank((CharSequence)this.condition.getCatalogName()) || StringUtils.isNotBlank((CharSequence)catalogName) && this.catalogMatcher.isMatch(catalogName);
            boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)schemaName) && StringUtils.isNotBlank((CharSequence)tableName) && StringUtils.isNotBlank((CharSequence)partitionName)) {
                flag = catalogFlag && this.dbMatcher.isMatch(schemaName) && this.tableMatcher.isMatch(tableName) && this.partitionMatcher.isMatch(partitionName);
            } else if (StringUtils.isNotBlank((CharSequence)schemaName) && StringUtils.isNotBlank((CharSequence)tableName)) {
                flag = catalogFlag && this.dbMatcher.isMatch(schemaName) && this.tableMatcher.isMatch(tableName);
            } else if (StringUtils.isNotBlank((CharSequence)schemaName)) {
                flag = catalogFlag && this.dbMatcher.isMatch(schemaName);
            } else if (StringUtils.isNotBlank((CharSequence)catalogName)) {
                flag = catalogFlag;
            }
            return flag;
        }

        public boolean isExcluded(QualifiedName qualifiedName) {
            if (this.matchType == MatchType.BLACK_LIST) {
                return this.isMatch(qualifiedName);
            }
            return !this.isMatch(qualifiedName);
        }

        public MetaDiscoveryCondition getCondition() {
            return this.condition;
        }

        public MatchType getMatchType() {
            return this.matchType;
        }

        public CatalogMatcher getCatalogMatcher() {
            return this.catalogMatcher;
        }

        public DbMatcher getDbMatcher() {
            return this.dbMatcher;
        }

        public TableMatcher getTableMatcher() {
            return this.tableMatcher;
        }

        public PartitionMatcher getPartitionMatcher() {
            return this.partitionMatcher;
        }

        public void setCondition(MetaDiscoveryCondition condition) {
            this.condition = condition;
        }

        public void setMatchType(MatchType matchType) {
            this.matchType = matchType;
        }

        public void setCatalogMatcher(CatalogMatcher catalogMatcher) {
            this.catalogMatcher = catalogMatcher;
        }

        public void setDbMatcher(DbMatcher dbMatcher) {
            this.dbMatcher = dbMatcher;
        }

        public void setTableMatcher(TableMatcher tableMatcher) {
            this.tableMatcher = tableMatcher;
        }

        public void setPartitionMatcher(PartitionMatcher partitionMatcher) {
            this.partitionMatcher = partitionMatcher;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatcherChain)) {
                return false;
            }
            MatcherChain other = (MatcherChain)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MetaDiscoveryCondition this$condition = this.getCondition();
            MetaDiscoveryCondition other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
                return false;
            }
            MatchType this$matchType = this.getMatchType();
            MatchType other$matchType = other.getMatchType();
            if (this$matchType == null ? other$matchType != null : !((Object)((Object)this$matchType)).equals((Object)other$matchType)) {
                return false;
            }
            CatalogMatcher this$catalogMatcher = this.getCatalogMatcher();
            CatalogMatcher other$catalogMatcher = other.getCatalogMatcher();
            if (this$catalogMatcher == null ? other$catalogMatcher != null : !this$catalogMatcher.equals(other$catalogMatcher)) {
                return false;
            }
            DbMatcher this$dbMatcher = this.getDbMatcher();
            DbMatcher other$dbMatcher = other.getDbMatcher();
            if (this$dbMatcher == null ? other$dbMatcher != null : !this$dbMatcher.equals(other$dbMatcher)) {
                return false;
            }
            TableMatcher this$tableMatcher = this.getTableMatcher();
            TableMatcher other$tableMatcher = other.getTableMatcher();
            if (this$tableMatcher == null ? other$tableMatcher != null : !this$tableMatcher.equals(other$tableMatcher)) {
                return false;
            }
            PartitionMatcher this$partitionMatcher = this.getPartitionMatcher();
            PartitionMatcher other$partitionMatcher = other.getPartitionMatcher();
            return !(this$partitionMatcher == null ? other$partitionMatcher != null : !this$partitionMatcher.equals(other$partitionMatcher));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MatcherChain;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MetaDiscoveryCondition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
            MatchType $matchType = this.getMatchType();
            result = result * 59 + ($matchType == null ? 43 : ((Object)((Object)$matchType)).hashCode());
            CatalogMatcher $catalogMatcher = this.getCatalogMatcher();
            result = result * 59 + ($catalogMatcher == null ? 43 : $catalogMatcher.hashCode());
            DbMatcher $dbMatcher = this.getDbMatcher();
            result = result * 59 + ($dbMatcher == null ? 43 : $dbMatcher.hashCode());
            TableMatcher $tableMatcher = this.getTableMatcher();
            result = result * 59 + ($tableMatcher == null ? 43 : $tableMatcher.hashCode());
            PartitionMatcher $partitionMatcher = this.getPartitionMatcher();
            result = result * 59 + ($partitionMatcher == null ? 43 : $partitionMatcher.hashCode());
            return result;
        }

        public String toString() {
            return "MetaDiscoveryFilter.MatcherChain(condition=" + this.getCondition() + ", matchType=" + this.getMatchType() + ", catalogMatcher=" + this.getCatalogMatcher() + ", dbMatcher=" + this.getDbMatcher() + ", tableMatcher=" + this.getTableMatcher() + ", partitionMatcher=" + this.getPartitionMatcher() + ")";
        }
    }
}

