/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils;

public class StorageUtils {
    static long kilo = 1024L;
    static long mega = kilo * kilo;
    static long giga = mega * kilo;
    static long tera = giga * kilo;

    public static String getSize(Long size) {
        if (size == null) {
            return "NaN";
        }
        return StorageUtils.getSize((double)size);
    }

    public static String getSize(Double size) {
        if (size == null) {
            return "NaN";
        }
        Object s = "";
        double kb = size / (double)kilo;
        double mb = kb / (double)kilo;
        double gb = mb / (double)kilo;
        double tb = gb / (double)kilo;
        s = Math.abs(size) < (double)kilo ? size + " Bytes" : (Math.abs(size) < (double)mega ? String.format("%.2f", kb) + " KB" : (Math.abs(size) < (double)giga ? String.format("%.2f", mb) + " MB" : (Math.abs(size) < (double)tera ? String.format("%.2f", gb) + " GB" : String.format("%.2f", tb) + " TB")));
        return s;
    }

    public static SizeInfo getSizeInfo(Long size) {
        SizeInfo sizeInfo = new SizeInfo();
        if (size == null) {
            sizeInfo.setUnit("Bytes");
            sizeInfo.setSize(0.0);
            return sizeInfo;
        }
        double kb = (double)size.longValue() / (double)kilo;
        double mb = kb / (double)kilo;
        double gb = mb / (double)kilo;
        double tb = gb / (double)kilo;
        if (Math.abs(size) < kilo) {
            sizeInfo.setUnit("Bytes");
            sizeInfo.setSize(size.doubleValue());
        } else if (Math.abs(size) < mega) {
            sizeInfo.setUnit("KB");
            sizeInfo.setSize(Double.valueOf(String.format("%.2f", kb)));
        } else if (Math.abs(size) < giga) {
            sizeInfo.setUnit("MB");
            sizeInfo.setSize(Double.valueOf(String.format("%.2f", mb)));
        } else if (Math.abs(size) < tera) {
            sizeInfo.setUnit("GB");
            sizeInfo.setSize(Double.valueOf(String.format("%.2f", gb)));
        } else {
            sizeInfo.setUnit("TB");
            sizeInfo.setSize(Double.valueOf(String.format("%.2f", tb)));
        }
        return sizeInfo;
    }

    public static Double getRealSize(String sizeString) {
        if (sizeString == null || "NaN".equals(sizeString)) {
            return 0.0;
        }
        int index = sizeString.indexOf(" ");
        Double number = Double.valueOf(sizeString.substring(0, index));
        String unit = sizeString.substring(index + 1);
        if ("Bytes".equals(unit)) {
            return number;
        }
        if ("KB".equals(unit)) {
            return number * (double)kilo;
        }
        if ("MB".equals(unit)) {
            return number * (double)kilo * (double)kilo;
        }
        if ("GB".equals(unit)) {
            return number * (double)kilo * (double)kilo * (double)kilo;
        }
        if ("TB".equals(unit)) {
            return number * (double)kilo * (double)kilo * (double)kilo * (double)kilo;
        }
        return number;
    }

    public static class SizeInfo {
        private Double size;
        private String unit;

        public Double getSize() {
            return this.size;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setSize(Double size) {
            this.size = size;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SizeInfo)) {
                return false;
            }
            SizeInfo other = (SizeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$size = this.getSize();
            Double other$size = other.getSize();
            if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SizeInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "StorageUtils.SizeInfo(size=" + this.getSize() + ", unit=" + this.getUnit() + ")";
        }
    }
}

