/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.profile.dataset;

import com.aliyun.migration.teleport.common.element.BaseElement;
import com.aliyun.migration.teleport.common.element.meta.dataset.QualifiedName;
import com.aliyun.migration.teleport.common.element.profile.CustomProfileItem;
import com.aliyun.migration.teleport.common.element.profile.dataset.PartitionProfile;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public class TableProfile
extends BaseElement
implements Serializable {
    private QualifiedName tableId;
    private Long originDataSize;
    private Long phyDataSize;
    private Integer partitionNum;
    private Long recordNum;
    private Integer fileNum;
    private Long averagePartitionSize;
    private Long averageFileSize;
    private List<CustomProfileItem> items;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incr(PartitionProfile partitionProfile) {
        TableProfile tableProfile = this;
        synchronized (tableProfile) {
            this.originDataSize = this.originDataSize + Optional.ofNullable(partitionProfile.getOriginDataSize()).orElse(0L);
            this.phyDataSize = this.phyDataSize + Optional.ofNullable(partitionProfile.getPhyDataSize()).orElse(0L);
            if (partitionProfile.getRecordNum() != null && partitionProfile.getRecordNum() > 0L) {
                this.recordNum = this.recordNum + partitionProfile.getRecordNum();
            }
            this.fileNum = this.fileNum + Optional.ofNullable(partitionProfile.getFileNum()).orElse(0);
            Integer n = this.partitionNum;
            this.partitionNum = this.partitionNum + 1;
            this.averagePartitionSize = this.partitionNum != 0 ? this.phyDataSize / (long)this.partitionNum.intValue() : 0L;
            this.averageFileSize = this.fileNum != 0 ? this.phyDataSize / (long)this.fileNum.intValue() : 0L;
        }
    }

    public void init(QualifiedName tableId) {
        this.setTableId(tableId);
        this.setOriginDataSize(0L);
        this.setPhyDataSize(0L);
        this.setRecordNum(0L);
        this.setFileNum(0);
        this.setPartitionNum(0);
        this.setAveragePartitionSize(0L);
        this.setAverageFileSize(0L);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableProfile)) {
            return false;
        }
        TableProfile other = (TableProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QualifiedName this$tableId = this.getTableId();
        QualifiedName other$tableId = other.getTableId();
        return !(this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableProfile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QualifiedName $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        return result;
    }

    public QualifiedName getTableId() {
        return this.tableId;
    }

    public Long getOriginDataSize() {
        return this.originDataSize;
    }

    public Long getPhyDataSize() {
        return this.phyDataSize;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public Long getRecordNum() {
        return this.recordNum;
    }

    public Integer getFileNum() {
        return this.fileNum;
    }

    public Long getAveragePartitionSize() {
        return this.averagePartitionSize;
    }

    public Long getAverageFileSize() {
        return this.averageFileSize;
    }

    public List<CustomProfileItem> getItems() {
        return this.items;
    }

    public void setTableId(QualifiedName tableId) {
        this.tableId = tableId;
    }

    public void setOriginDataSize(Long originDataSize) {
        this.originDataSize = originDataSize;
    }

    public void setPhyDataSize(Long phyDataSize) {
        this.phyDataSize = phyDataSize;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setRecordNum(Long recordNum) {
        this.recordNum = recordNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }

    public void setAveragePartitionSize(Long averagePartitionSize) {
        this.averagePartitionSize = averagePartitionSize;
    }

    public void setAverageFileSize(Long averageFileSize) {
        this.averageFileSize = averageFileSize;
    }

    public void setItems(List<CustomProfileItem> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "TableProfile(tableId=" + this.getTableId() + ", originDataSize=" + this.getOriginDataSize() + ", phyDataSize=" + this.getPhyDataSize() + ", partitionNum=" + this.getPartitionNum() + ", recordNum=" + this.getRecordNum() + ", fileNum=" + this.getFileNum() + ", averagePartitionSize=" + this.getAveragePartitionSize() + ", averageFileSize=" + this.getAverageFileSize() + ", items=" + this.getItems() + ")";
    }
}

