/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.profile.dataset;

import com.aliyun.migration.teleport.common.element.BaseElement;
import com.aliyun.migration.teleport.common.element.meta.dataset.QualifiedName;
import com.aliyun.migration.teleport.common.element.meta.dataset.TableMeta;
import com.aliyun.migration.teleport.common.element.profile.CustomProfileItem;
import com.aliyun.migration.teleport.common.element.profile.dataset.TableProfile;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;

public class SchemaProfile
extends BaseElement
implements Serializable {
    private QualifiedName schemaId;
    private Long originDataSize;
    private Long tableNum;
    private Long partitionNum;
    private Long recordNum;
    private Integer fileNum;
    private Integer viewNum;
    private Integer funcNum;
    private Integer ptTableNum;
    private Integer noPtTableNum;
    private Integer etTableNum;
    private Integer transactionalNum;
    private Long phyDataSize;
    private List<CustomProfileItem> items;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incr(TableMeta tableMeta, TableProfile tableProfile) {
        SchemaProfile schemaProfile = this;
        synchronized (schemaProfile) {
            this.originDataSize = this.originDataSize + Optional.ofNullable(tableProfile.getOriginDataSize()).orElse(0L);
            this.tableNum = this.tableNum + 1L;
            this.partitionNum = this.partitionNum + (long)Optional.ofNullable(tableProfile.getPartitionNum()).orElse(0).intValue();
            if (tableProfile.getRecordNum() > 0L) {
                this.recordNum = this.recordNum + tableProfile.getRecordNum();
            }
            this.fileNum = this.fileNum + Optional.ofNullable(tableProfile.getFileNum()).orElse(0);
            this.phyDataSize = this.phyDataSize + Optional.ofNullable(tableProfile.getPhyDataSize()).orElse(0L);
            int viewNum = TableMeta.TableType.isView(tableMeta.getTableType()) ? 1 : 0;
            this.viewNum = this.viewNum + viewNum;
            int ptTableNum = BooleanUtils.isTrue((Boolean)tableMeta.getIsPartitionTable()) ? 1 : 0;
            this.ptTableNum = this.ptTableNum + ptTableNum;
            int noPtTableNum = BooleanUtils.isTrue((Boolean)tableMeta.getIsPartitionTable()) ? 0 : 1;
            this.noPtTableNum = this.noPtTableNum + noPtTableNum;
            int etTableNum = TableMeta.TableType.EXTERNAL_TABLE.equals((Object)tableMeta.getTableType()) ? 1 : 0;
            this.etTableNum = this.etTableNum + etTableNum;
            int transactionalNum = BooleanUtils.isTrue((Boolean)tableMeta.getIsTransactional()) ? 1 : 0;
            this.transactionalNum = this.transactionalNum + transactionalNum;
        }
    }

    public void init(QualifiedName schemaId) {
        this.setSchemaId(schemaId);
        this.setOriginDataSize(0L);
        this.setTableNum(0L);
        this.setPartitionNum(0L);
        this.setRecordNum(0L);
        this.setFileNum(0);
        this.setViewNum(0);
        this.setFuncNum(0);
        this.setPtTableNum(0);
        this.setNoPtTableNum(0);
        this.setEtTableNum(0);
        this.setTransactionalNum(0);
        this.setPhyDataSize(0L);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaProfile)) {
            return false;
        }
        SchemaProfile other = (SchemaProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QualifiedName this$schemaId = this.getSchemaId();
        QualifiedName other$schemaId = other.getSchemaId();
        return !(this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SchemaProfile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QualifiedName $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        return result;
    }

    public QualifiedName getSchemaId() {
        return this.schemaId;
    }

    public Long getOriginDataSize() {
        return this.originDataSize;
    }

    public Long getTableNum() {
        return this.tableNum;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public Long getRecordNum() {
        return this.recordNum;
    }

    public Integer getFileNum() {
        return this.fileNum;
    }

    public Integer getViewNum() {
        return this.viewNum;
    }

    public Integer getFuncNum() {
        return this.funcNum;
    }

    public Integer getPtTableNum() {
        return this.ptTableNum;
    }

    public Integer getNoPtTableNum() {
        return this.noPtTableNum;
    }

    public Integer getEtTableNum() {
        return this.etTableNum;
    }

    public Integer getTransactionalNum() {
        return this.transactionalNum;
    }

    public Long getPhyDataSize() {
        return this.phyDataSize;
    }

    public List<CustomProfileItem> getItems() {
        return this.items;
    }

    public void setSchemaId(QualifiedName schemaId) {
        this.schemaId = schemaId;
    }

    public void setOriginDataSize(Long originDataSize) {
        this.originDataSize = originDataSize;
    }

    public void setTableNum(Long tableNum) {
        this.tableNum = tableNum;
    }

    public void setPartitionNum(Long partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setRecordNum(Long recordNum) {
        this.recordNum = recordNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }

    public void setViewNum(Integer viewNum) {
        this.viewNum = viewNum;
    }

    public void setFuncNum(Integer funcNum) {
        this.funcNum = funcNum;
    }

    public void setPtTableNum(Integer ptTableNum) {
        this.ptTableNum = ptTableNum;
    }

    public void setNoPtTableNum(Integer noPtTableNum) {
        this.noPtTableNum = noPtTableNum;
    }

    public void setEtTableNum(Integer etTableNum) {
        this.etTableNum = etTableNum;
    }

    public void setTransactionalNum(Integer transactionalNum) {
        this.transactionalNum = transactionalNum;
    }

    public void setPhyDataSize(Long phyDataSize) {
        this.phyDataSize = phyDataSize;
    }

    public void setItems(List<CustomProfileItem> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "SchemaProfile(schemaId=" + this.getSchemaId() + ", originDataSize=" + this.getOriginDataSize() + ", tableNum=" + this.getTableNum() + ", partitionNum=" + this.getPartitionNum() + ", recordNum=" + this.getRecordNum() + ", fileNum=" + this.getFileNum() + ", viewNum=" + this.getViewNum() + ", funcNum=" + this.getFuncNum() + ", ptTableNum=" + this.getPtTableNum() + ", noPtTableNum=" + this.getNoPtTableNum() + ", etTableNum=" + this.getEtTableNum() + ", transactionalNum=" + this.getTransactionalNum() + ", phyDataSize=" + this.getPhyDataSize() + ", items=" + this.getItems() + ")";
    }
}

