/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.profile.dataset;

import com.aliyun.migration.teleport.common.element.BaseElement;
import com.aliyun.migration.teleport.common.element.meta.dataset.QualifiedName;
import com.aliyun.migration.teleport.common.element.profile.CustomProfileItem;
import com.aliyun.migration.teleport.common.element.profile.dataset.SchemaProfile;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public class CatalogProfile
extends BaseElement
implements Serializable {
    private QualifiedName catalogId;
    private Long originDataSize;
    private Long schemaNum;
    private Long tableNum;
    private Long partitionNum;
    private Long recordNum;
    private Integer fileNum;
    private Integer viewNum;
    private Integer funcNum;
    private Integer ptTableNum;
    private Integer noPtTableNum;
    private Integer etTableNum;
    private Integer transactionalNum;
    private Long phyDataSize;
    private List<CustomProfileItem> items;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incr(SchemaProfile schemaProfile) {
        CatalogProfile catalogProfile = this;
        synchronized (catalogProfile) {
            this.originDataSize = this.originDataSize + Optional.ofNullable(schemaProfile.getOriginDataSize()).orElse(0L);
            this.schemaNum = this.schemaNum + 1L;
            this.tableNum = this.tableNum + schemaProfile.getTableNum();
            this.partitionNum = this.partitionNum + Optional.ofNullable(schemaProfile.getPartitionNum()).orElse(0L);
            if (schemaProfile.getRecordNum() > 0L) {
                this.recordNum = this.recordNum + schemaProfile.getRecordNum();
            }
            this.fileNum = this.fileNum + Optional.ofNullable(schemaProfile.getFileNum()).orElse(0);
            this.phyDataSize = this.phyDataSize + Optional.ofNullable(schemaProfile.getPhyDataSize()).orElse(0L);
            this.viewNum = this.viewNum + schemaProfile.getViewNum();
            this.ptTableNum = this.ptTableNum + schemaProfile.getPtTableNum();
            this.noPtTableNum = this.noPtTableNum + schemaProfile.getNoPtTableNum();
            this.etTableNum = this.etTableNum + schemaProfile.getEtTableNum();
            this.transactionalNum = this.transactionalNum + schemaProfile.getTransactionalNum();
        }
    }

    public void init(QualifiedName catalogId) {
        this.setCatalogId(catalogId);
        this.setOriginDataSize(0L);
        this.setSchemaNum(0L);
        this.setTableNum(0L);
        this.setPartitionNum(0L);
        this.setRecordNum(0L);
        this.setFileNum(0);
        this.setViewNum(0);
        this.setFuncNum(0);
        this.setPtTableNum(0);
        this.setNoPtTableNum(0);
        this.setEtTableNum(0);
        this.setTransactionalNum(0);
        this.setPhyDataSize(0L);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogProfile)) {
            return false;
        }
        CatalogProfile other = (CatalogProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QualifiedName this$catalogId = this.getCatalogId();
        QualifiedName other$catalogId = other.getCatalogId();
        return !(this$catalogId == null ? other$catalogId != null : !((Object)this$catalogId).equals(other$catalogId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CatalogProfile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QualifiedName $catalogId = this.getCatalogId();
        result = result * 59 + ($catalogId == null ? 43 : ((Object)$catalogId).hashCode());
        return result;
    }

    public QualifiedName getCatalogId() {
        return this.catalogId;
    }

    public Long getOriginDataSize() {
        return this.originDataSize;
    }

    public Long getSchemaNum() {
        return this.schemaNum;
    }

    public Long getTableNum() {
        return this.tableNum;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public Long getRecordNum() {
        return this.recordNum;
    }

    public Integer getFileNum() {
        return this.fileNum;
    }

    public Integer getViewNum() {
        return this.viewNum;
    }

    public Integer getFuncNum() {
        return this.funcNum;
    }

    public Integer getPtTableNum() {
        return this.ptTableNum;
    }

    public Integer getNoPtTableNum() {
        return this.noPtTableNum;
    }

    public Integer getEtTableNum() {
        return this.etTableNum;
    }

    public Integer getTransactionalNum() {
        return this.transactionalNum;
    }

    public Long getPhyDataSize() {
        return this.phyDataSize;
    }

    public List<CustomProfileItem> getItems() {
        return this.items;
    }

    public void setCatalogId(QualifiedName catalogId) {
        this.catalogId = catalogId;
    }

    public void setOriginDataSize(Long originDataSize) {
        this.originDataSize = originDataSize;
    }

    public void setSchemaNum(Long schemaNum) {
        this.schemaNum = schemaNum;
    }

    public void setTableNum(Long tableNum) {
        this.tableNum = tableNum;
    }

    public void setPartitionNum(Long partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setRecordNum(Long recordNum) {
        this.recordNum = recordNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }

    public void setViewNum(Integer viewNum) {
        this.viewNum = viewNum;
    }

    public void setFuncNum(Integer funcNum) {
        this.funcNum = funcNum;
    }

    public void setPtTableNum(Integer ptTableNum) {
        this.ptTableNum = ptTableNum;
    }

    public void setNoPtTableNum(Integer noPtTableNum) {
        this.noPtTableNum = noPtTableNum;
    }

    public void setEtTableNum(Integer etTableNum) {
        this.etTableNum = etTableNum;
    }

    public void setTransactionalNum(Integer transactionalNum) {
        this.transactionalNum = transactionalNum;
    }

    public void setPhyDataSize(Long phyDataSize) {
        this.phyDataSize = phyDataSize;
    }

    public void setItems(List<CustomProfileItem> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "CatalogProfile(catalogId=" + this.getCatalogId() + ", originDataSize=" + this.getOriginDataSize() + ", schemaNum=" + this.getSchemaNum() + ", tableNum=" + this.getTableNum() + ", partitionNum=" + this.getPartitionNum() + ", recordNum=" + this.getRecordNum() + ", fileNum=" + this.getFileNum() + ", viewNum=" + this.getViewNum() + ", funcNum=" + this.getFuncNum() + ", ptTableNum=" + this.getPtTableNum() + ", noPtTableNum=" + this.getNoPtTableNum() + ", etTableNum=" + this.getEtTableNum() + ", transactionalNum=" + this.getTransactionalNum() + ", phyDataSize=" + this.getPhyDataSize() + ", items=" + this.getItems() + ")";
    }
}

