/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.migration;

import com.aliyun.migration.teleport.common.dto.migration.BatchInstanceOverview;
import com.aliyun.migration.teleport.common.dto.migration.DataValidationOverviewVO;
import com.aliyun.migration.teleport.common.utils.TimeUtil;
import java.io.Serializable;
import java.util.Optional;

public class DataSyncTaskVO
implements Serializable {
    private String version;
    private String taskName;
    private String taskCreateTime;
    private String taskType;
    private Long totalTasks;
    private Long successTasks;
    private Long failTasks;
    private String errorMessage;
    private String createTime;
    private String startTime;
    private String endTime;
    private String taskStatus;
    private String taskResult;
    private Double taskProgress;
    private String execDuration;
    private String taskProgressPretty;
    private String taskTypePretty;
    private String taskStatusPretty;
    private String taskResultPretty;

    public void populate() {
        long success = Optional.ofNullable(this.successTasks).orElse(0L);
        long fail = Optional.ofNullable(this.failTasks).orElse(0L);
        long completeTasks = success + fail;
        if (this.totalTasks != null && this.totalTasks != 0L) {
            this.taskProgress = (double)completeTasks / (double)this.totalTasks.longValue();
            this.taskProgressPretty = String.format("%.2f%%", this.taskProgress * 100.0);
            if (fail > 0L) {
                this.taskResultPretty = success > 0L ? DataSyncTaskResult.PART_FAIL.desc : DataSyncTaskResult.FAIL.desc;
                String string = this.taskResult = success > 0L ? DataSyncTaskResult.PART_FAIL.name() : DataSyncTaskResult.FAIL.name();
                if (completeTasks == this.totalTasks) {
                    this.taskStatusPretty = DataSyncTaskStatus.FINISHED.desc;
                    this.taskStatus = DataSyncTaskStatus.FINISHED.name();
                } else {
                    this.taskStatusPretty = DataSyncTaskStatus.RUNNING.desc;
                    this.taskStatus = DataSyncTaskStatus.RUNNING.name();
                }
            } else if (completeTasks == this.totalTasks) {
                this.taskStatusPretty = DataSyncTaskStatus.FINISHED.desc;
                this.taskStatus = DataSyncTaskStatus.FINISHED.name();
                this.taskResult = DataSyncTaskResult.SUCCESS.name();
                this.taskResultPretty = DataSyncTaskResult.SUCCESS.desc;
            } else if (completeTasks == 0L) {
                this.taskStatusPretty = DataSyncTaskStatus.INIT.desc;
                this.taskStatus = DataSyncTaskStatus.INIT.name();
                this.taskResult = DataSyncTaskResult.NO_RESULT.name();
                this.taskResultPretty = DataSyncTaskResult.NO_RESULT.desc;
            } else {
                this.taskStatusPretty = DataSyncTaskStatus.RUNNING.desc;
                this.taskStatus = DataSyncTaskStatus.RUNNING.name();
                this.taskResult = DataSyncTaskResult.RUNNING.name();
                this.taskResultPretty = DataSyncTaskResult.RUNNING.desc;
            }
        } else {
            this.taskProgress = 100.0;
            this.taskProgressPretty = "100.00%";
            this.taskStatusPretty = DataSyncTaskStatus.FINISHED.desc;
            this.taskStatus = DataSyncTaskStatus.FINISHED.name();
            this.taskResult = DataSyncTaskResult.NO_RESULT.name();
            this.taskResultPretty = DataSyncTaskResult.NO_RESULT.desc;
        }
        this.execDuration = TimeUtil.durationFormat(TimeUtil.between(this.startTime, this.endTime));
        DataSyncTaskType dataSyncTaskType = DataSyncTaskType.of(this.taskType);
        if (dataSyncTaskType != null) {
            this.taskTypePretty = dataSyncTaskType.desc;
        }
    }

    public static DataSyncTaskVO from(BatchInstanceOverview vo, String version) {
        if (vo == null) {
            return null;
        }
        DataSyncTaskVO result = new DataSyncTaskVO();
        result.setVersion(version);
        result.setTaskName(vo.getJobName());
        result.setTaskCreateTime(vo.getCreateTime());
        result.setTaskType(vo.getTaskType().name());
        result.setTotalTasks(vo.getTotalTaskCount());
        result.setSuccessTasks(vo.getSuccessTaskCount());
        result.setFailTasks(vo.getFailedTaskCount());
        result.setErrorMessage(vo.getErrorMessage());
        result.setCreateTime(vo.getCreateTime());
        result.setStartTime(vo.getStartTime());
        result.setEndTime(vo.getEndTime());
        return result;
    }

    public static DataSyncTaskVO from(DataValidationOverviewVO vo, String version) {
        DataSyncTaskVO result = new DataSyncTaskVO();
        result.setTaskType(DataSyncTaskType.DATA_VALIDATION.name());
        if (vo == null) {
            return null;
        }
        result.setVersion(version);
        result.setTaskName(version);
        result.setTaskCreateTime(vo.getTaskCreateTime());
        result.setTotalTasks(vo.getTotalStepCount());
        result.setSuccessTasks(vo.getSuccessStepCount());
        result.setFailTasks(vo.getFailStepCount());
        result.setCreateTime(vo.getCreateTime());
        result.setStartTime(vo.getStartTime());
        result.setEndTime(vo.getEndTime());
        if (vo.getFailTaskCount() != null && vo.getFailTaskCount() > 0L) {
            result.setErrorMessage("\u5b58\u5728\u51fa\u9519\u4efb\u52a1\uff0c\u53c2\u8003\u8be6\u60c5");
        }
        return result;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskCreateTime() {
        return this.taskCreateTime;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public Long getTotalTasks() {
        return this.totalTasks;
    }

    public Long getSuccessTasks() {
        return this.successTasks;
    }

    public Long getFailTasks() {
        return this.failTasks;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public String getTaskResult() {
        return this.taskResult;
    }

    public Double getTaskProgress() {
        return this.taskProgress;
    }

    public String getExecDuration() {
        return this.execDuration;
    }

    public String getTaskProgressPretty() {
        return this.taskProgressPretty;
    }

    public String getTaskTypePretty() {
        return this.taskTypePretty;
    }

    public String getTaskStatusPretty() {
        return this.taskStatusPretty;
    }

    public String getTaskResultPretty() {
        return this.taskResultPretty;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskCreateTime(String taskCreateTime) {
        this.taskCreateTime = taskCreateTime;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setTotalTasks(Long totalTasks) {
        this.totalTasks = totalTasks;
    }

    public void setSuccessTasks(Long successTasks) {
        this.successTasks = successTasks;
    }

    public void setFailTasks(Long failTasks) {
        this.failTasks = failTasks;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setTaskResult(String taskResult) {
        this.taskResult = taskResult;
    }

    public void setTaskProgress(Double taskProgress) {
        this.taskProgress = taskProgress;
    }

    public void setExecDuration(String execDuration) {
        this.execDuration = execDuration;
    }

    public void setTaskProgressPretty(String taskProgressPretty) {
        this.taskProgressPretty = taskProgressPretty;
    }

    public void setTaskTypePretty(String taskTypePretty) {
        this.taskTypePretty = taskTypePretty;
    }

    public void setTaskStatusPretty(String taskStatusPretty) {
        this.taskStatusPretty = taskStatusPretty;
    }

    public void setTaskResultPretty(String taskResultPretty) {
        this.taskResultPretty = taskResultPretty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSyncTaskVO)) {
            return false;
        }
        DataSyncTaskVO other = (DataSyncTaskVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalTasks = this.getTotalTasks();
        Long other$totalTasks = other.getTotalTasks();
        if (this$totalTasks == null ? other$totalTasks != null : !((Object)this$totalTasks).equals(other$totalTasks)) {
            return false;
        }
        Long this$successTasks = this.getSuccessTasks();
        Long other$successTasks = other.getSuccessTasks();
        if (this$successTasks == null ? other$successTasks != null : !((Object)this$successTasks).equals(other$successTasks)) {
            return false;
        }
        Long this$failTasks = this.getFailTasks();
        Long other$failTasks = other.getFailTasks();
        if (this$failTasks == null ? other$failTasks != null : !((Object)this$failTasks).equals(other$failTasks)) {
            return false;
        }
        Double this$taskProgress = this.getTaskProgress();
        Double other$taskProgress = other.getTaskProgress();
        if (this$taskProgress == null ? other$taskProgress != null : !((Object)this$taskProgress).equals(other$taskProgress)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$taskCreateTime = this.getTaskCreateTime();
        String other$taskCreateTime = other.getTaskCreateTime();
        if (this$taskCreateTime == null ? other$taskCreateTime != null : !this$taskCreateTime.equals(other$taskCreateTime)) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$taskStatus = this.getTaskStatus();
        String other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !this$taskStatus.equals(other$taskStatus)) {
            return false;
        }
        String this$taskResult = this.getTaskResult();
        String other$taskResult = other.getTaskResult();
        if (this$taskResult == null ? other$taskResult != null : !this$taskResult.equals(other$taskResult)) {
            return false;
        }
        String this$execDuration = this.getExecDuration();
        String other$execDuration = other.getExecDuration();
        if (this$execDuration == null ? other$execDuration != null : !this$execDuration.equals(other$execDuration)) {
            return false;
        }
        String this$taskProgressPretty = this.getTaskProgressPretty();
        String other$taskProgressPretty = other.getTaskProgressPretty();
        if (this$taskProgressPretty == null ? other$taskProgressPretty != null : !this$taskProgressPretty.equals(other$taskProgressPretty)) {
            return false;
        }
        String this$taskTypePretty = this.getTaskTypePretty();
        String other$taskTypePretty = other.getTaskTypePretty();
        if (this$taskTypePretty == null ? other$taskTypePretty != null : !this$taskTypePretty.equals(other$taskTypePretty)) {
            return false;
        }
        String this$taskStatusPretty = this.getTaskStatusPretty();
        String other$taskStatusPretty = other.getTaskStatusPretty();
        if (this$taskStatusPretty == null ? other$taskStatusPretty != null : !this$taskStatusPretty.equals(other$taskStatusPretty)) {
            return false;
        }
        String this$taskResultPretty = this.getTaskResultPretty();
        String other$taskResultPretty = other.getTaskResultPretty();
        return !(this$taskResultPretty == null ? other$taskResultPretty != null : !this$taskResultPretty.equals(other$taskResultPretty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSyncTaskVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalTasks = this.getTotalTasks();
        result = result * 59 + ($totalTasks == null ? 43 : ((Object)$totalTasks).hashCode());
        Long $successTasks = this.getSuccessTasks();
        result = result * 59 + ($successTasks == null ? 43 : ((Object)$successTasks).hashCode());
        Long $failTasks = this.getFailTasks();
        result = result * 59 + ($failTasks == null ? 43 : ((Object)$failTasks).hashCode());
        Double $taskProgress = this.getTaskProgress();
        result = result * 59 + ($taskProgress == null ? 43 : ((Object)$taskProgress).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $taskCreateTime = this.getTaskCreateTime();
        result = result * 59 + ($taskCreateTime == null ? 43 : $taskCreateTime.hashCode());
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : $taskStatus.hashCode());
        String $taskResult = this.getTaskResult();
        result = result * 59 + ($taskResult == null ? 43 : $taskResult.hashCode());
        String $execDuration = this.getExecDuration();
        result = result * 59 + ($execDuration == null ? 43 : $execDuration.hashCode());
        String $taskProgressPretty = this.getTaskProgressPretty();
        result = result * 59 + ($taskProgressPretty == null ? 43 : $taskProgressPretty.hashCode());
        String $taskTypePretty = this.getTaskTypePretty();
        result = result * 59 + ($taskTypePretty == null ? 43 : $taskTypePretty.hashCode());
        String $taskStatusPretty = this.getTaskStatusPretty();
        result = result * 59 + ($taskStatusPretty == null ? 43 : $taskStatusPretty.hashCode());
        String $taskResultPretty = this.getTaskResultPretty();
        result = result * 59 + ($taskResultPretty == null ? 43 : $taskResultPretty.hashCode());
        return result;
    }

    public String toString() {
        return "DataSyncTaskVO(version=" + this.getVersion() + ", taskName=" + this.getTaskName() + ", taskCreateTime=" + this.getTaskCreateTime() + ", taskType=" + this.getTaskType() + ", totalTasks=" + this.getTotalTasks() + ", successTasks=" + this.getSuccessTasks() + ", failTasks=" + this.getFailTasks() + ", errorMessage=" + this.getErrorMessage() + ", createTime=" + this.getCreateTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", taskStatus=" + this.getTaskStatus() + ", taskResult=" + this.getTaskResult() + ", taskProgress=" + this.getTaskProgress() + ", execDuration=" + this.getExecDuration() + ", taskProgressPretty=" + this.getTaskProgressPretty() + ", taskTypePretty=" + this.getTaskTypePretty() + ", taskStatusPretty=" + this.getTaskStatusPretty() + ", taskResultPretty=" + this.getTaskResultPretty() + ")";
    }

    public static enum DataSyncTaskResult {
        SUCCESS("\u6267\u884c\u6210\u529f"),
        FAIL("\u6267\u884c\u5931\u8d25"),
        PART_FAIL("\u90e8\u5206\u5931\u8d25"),
        RUNNING("\u8fd0\u884c\u4e2d"),
        NO_RESULT("-");

        public String desc;

        private DataSyncTaskResult(String desc) {
            this.desc = desc;
        }
    }

    public static enum DataSyncTaskStatus {
        FINISHED("\u5df2\u5b8c\u6210"),
        RUNNING("\u8fd0\u884c\u4e2d"),
        INIT("\u5f85\u6267\u884c");

        public String desc;

        private DataSyncTaskStatus(String desc) {
            this.desc = desc;
        }
    }

    public static enum DataSyncTaskType {
        SCHEMA_MIGRATION("\u7ed3\u6784\u8fc1\u79fb"),
        DATA_MIGRATION("\u6570\u636e\u8fc1\u79fb"),
        DATA_VALIDATION("\u6570\u636e\u6821\u9a8c");

        public String desc;

        private DataSyncTaskType(String desc) {
            this.desc = desc;
        }

        public static DataSyncTaskType of(String value) {
            try {
                return DataSyncTaskType.valueOf(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

