/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.meta.data;

import com.aliyun.migration.teleport.common.dto.meta.condition.MetaDiscoveryCondition;
import com.aliyun.migration.teleport.common.dto.meta.data.MetaVersion;
import com.aliyun.migration.teleport.common.dto.meta.enums.DiscoveryType;
import com.aliyun.migration.teleport.common.dto.meta.enums.JobStatus;
import com.aliyun.migration.teleport.common.element.meta.Version;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

public class MetaDiscoveryJobDTO
implements Serializable {
    private Long id;
    private MetaVersion metaVersion;
    private Version.VersionType taskType;
    private JobStatus jobStatus;
    private DiscoveryType discoveryType;
    private List<MetaDiscoveryCondition> conditions;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String filePath;
    private String errorCode;
    private String errorMessage;

    public static MetaDiscoveryJobDTO createBaseJob(String datasourceId) {
        MetaDiscoveryJobDTO metaDiscoveryJob = new MetaDiscoveryJobDTO();
        metaDiscoveryJob.setTaskType(Version.VersionType.BASE);
        metaDiscoveryJob.setMetaVersion(MetaVersion.ofLatestBaseVersion(Long.parseLong(datasourceId)));
        metaDiscoveryJob.setJobStatus(JobStatus.INIT);
        return metaDiscoveryJob;
    }

    public static MetaDiscoveryJobDTO createCustomJob(String datasourceId, List<MetaDiscoveryCondition> conditions) {
        MetaDiscoveryJobDTO metaDiscoveryJob = new MetaDiscoveryJobDTO();
        metaDiscoveryJob.setTaskType(Version.VersionType.CUSTOM);
        metaDiscoveryJob.setMetaVersion(MetaVersion.ofLatestCustomVersion(Long.parseLong(datasourceId)));
        metaDiscoveryJob.setJobStatus(JobStatus.INIT);
        metaDiscoveryJob.setConditions(conditions);
        return metaDiscoveryJob;
    }

    public Long getId() {
        return this.id;
    }

    public MetaVersion getMetaVersion() {
        return this.metaVersion;
    }

    public Version.VersionType getTaskType() {
        return this.taskType;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public List<MetaDiscoveryCondition> getConditions() {
        return this.conditions;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMetaVersion(MetaVersion metaVersion) {
        this.metaVersion = metaVersion;
    }

    public void setTaskType(Version.VersionType taskType) {
        this.taskType = taskType;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setDiscoveryType(DiscoveryType discoveryType) {
        this.discoveryType = discoveryType;
    }

    public void setConditions(List<MetaDiscoveryCondition> conditions) {
        this.conditions = conditions;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaDiscoveryJobDTO)) {
            return false;
        }
        MetaDiscoveryJobDTO other = (MetaDiscoveryJobDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        MetaVersion this$metaVersion = this.getMetaVersion();
        MetaVersion other$metaVersion = other.getMetaVersion();
        if (this$metaVersion == null ? other$metaVersion != null : !((Object)this$metaVersion).equals(other$metaVersion)) {
            return false;
        }
        Version.VersionType this$taskType = this.getTaskType();
        Version.VersionType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        JobStatus this$jobStatus = this.getJobStatus();
        JobStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
            return false;
        }
        DiscoveryType this$discoveryType = this.getDiscoveryType();
        DiscoveryType other$discoveryType = other.getDiscoveryType();
        if (this$discoveryType == null ? other$discoveryType != null : !((Object)((Object)this$discoveryType)).equals((Object)other$discoveryType)) {
            return false;
        }
        List<MetaDiscoveryCondition> this$conditions = this.getConditions();
        List<MetaDiscoveryCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaDiscoveryJobDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        MetaVersion $metaVersion = this.getMetaVersion();
        result = result * 59 + ($metaVersion == null ? 43 : ((Object)$metaVersion).hashCode());
        Version.VersionType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        JobStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
        DiscoveryType $discoveryType = this.getDiscoveryType();
        result = result * 59 + ($discoveryType == null ? 43 : ((Object)((Object)$discoveryType)).hashCode());
        List<MetaDiscoveryCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "MetaDiscoveryJobDTO(id=" + this.getId() + ", metaVersion=" + this.getMetaVersion() + ", taskType=" + this.getTaskType() + ", jobStatus=" + this.getJobStatus() + ", discoveryType=" + this.getDiscoveryType() + ", conditions=" + this.getConditions() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", filePath=" + this.getFilePath() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ")";
    }
}

