/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.common.tenant;

import com.aliyun.migration.teleport.common.dto.common.tenant.TenantDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantThreadLocal {
    private static final Logger log = LoggerFactory.getLogger(TenantThreadLocal.class);
    private static final ThreadLocal<TenantDTO> TENANT_THREAD_LOCAL = new ThreadLocal();

    public static void setTenant(TenantDTO tenantInfo) {
        TENANT_THREAD_LOCAL.set(tenantInfo);
    }

    public static String getTenantId() {
        if (null == TENANT_THREAD_LOCAL.get()) {
            log.warn("[Tenant] tenant is null");
            return null;
        }
        return TENANT_THREAD_LOCAL.get().getAdminUserId();
    }

    public static TenantDTO getTenant() {
        return TENANT_THREAD_LOCAL.get();
    }

    public static void removeTenantId() {
        TENANT_THREAD_LOCAL.remove();
    }
}

