/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.constants;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class MessageQueue {
    public static final String QUEUE_META_DISCOVERY = "tele-meta.discovery";
    public static final String TELEPORT_CALLBACK_EXCHANGE = "teleport-callback.exchange";
    public static final String TELEPORT_CALLBACK_QUEUE_PREFIX = "teleport.callback-queue.";
    private static final String TELEPORT_TOPIC_PREFIX = "teleport.callback-topic.";

    public static enum TeleportOperatorType {
        TeleportAgent(10L, "\u5b88\u62a4\u8fdb\u7a0b"),
        MetaListener(11L, "\u5143\u6570\u636e\u76d1\u542c"),
        DatasetListener(12L, "\u8868\u7ea7\u5143\u6570\u636e"),
        WorkflowListener(13L, "\u4efb\u52a1\u8c03\u5ea6\u5143\u4fe1\u606f"),
        DataSyncPlan(15L, "\u6570\u636e\u8fc1\u79fb\u8ba1\u5212"),
        WorkflowTransPlan(16L, "\u8c03\u5ea6\u8fc1\u79fb\u8ba1\u5212"),
        CatalogSync(20L, "\u6570\u636e\u4ed3\u5143\u6570\u636e\u540c\u6b65"),
        FileMetaSync(21L, "\u6570\u636e\u6e56\u5143\u6570\u636e\u540c\u6b65"),
        LineageMetaSync(22L, "\u8840\u7f18\u5143\u6570\u636e\u540c\u6b65"),
        TableDataSync(30L, "\u8868\u6570\u636e\u540c\u6b65"),
        FileDataSync(31L, "\u6587\u4ef6\u6570\u636e\u540c\u6b65"),
        SQLTransform(40L, "SQL\u8f6c\u6362"),
        DDLTransform(41L, "DDL\u8f6c\u6362"),
        DMLTransform(42L, "DML\u8f6c\u6362"),
        WorkflowTrans(50L, "\u8c03\u5ea6\u8fc1\u79fb"),
        ExecuteJob(60L, "\u4f5c\u4e1a\u6267\u884c"),
        TablePartitionValidator(61L, "\u5e93\u8868\u5206\u533a\u5b8c\u6574\u6027\u6821\u9a8c"),
        OfflineDataValidator(32L, "\u6570\u636e\u6821\u9a8c"),
        DataVerify(62L, "\u6570\u636e\u6821\u9a8c"),
        ResourceOperation(63L, "\u8d44\u6e90\u64cd\u4f5c"),
        VirtualNode(70L, "\u865a\u62df\u8282\u70b9"),
        WorkflowSubmitNode(74L, "\u8c03\u5ea6\u63d0\u4ea4\u5230\u76ee\u6807\u7aef"),
        TimerTrigger(90L, "\u5b9a\u65f6\u89e6\u53d1\u5668"),
        ManualTrigger(91L, "\u624b\u52a8\u89e6\u53d1\u5668"),
        TablePartitionSyncTrigger(92L, "\u6570\u636e\u540c\u6b65\u89e6\u53d1\u5668"),
        WorkflowNodeTrigger(93L, "\u8c03\u5ea6\u8fc1\u79fb\u89e6\u53d1\u5668");

        private Long oid;
        private String description;

        private TeleportOperatorType(Long oid, String description) {
            this.oid = oid;
            this.description = description;
        }

        public Long getOid() {
            return this.oid;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTopic() {
            return MessageQueue.TELEPORT_TOPIC_PREFIX + this.name();
        }

        public String getQueueName() {
            return MessageQueue.TELEPORT_CALLBACK_QUEUE_PREFIX + this.name();
        }

        public static Map<String, Long> map() {
            return Arrays.stream(TeleportOperatorType.values()).collect(Collectors.toMap(TeleportOperatorType::getTopic, TeleportOperatorType::getOid));
        }

        public static Map<Long, TeleportOperatorType> id2topic() {
            return Arrays.stream(TeleportOperatorType.values()).collect(Collectors.toMap(TeleportOperatorType::getOid, t -> t));
        }

        public static Map<Long, String> id2desc() {
            return Arrays.stream(TeleportOperatorType.values()).collect(Collectors.toMap(TeleportOperatorType::getOid, TeleportOperatorType::getDescription));
        }

        public static Map<Long, String> id2name() {
            return Arrays.stream(TeleportOperatorType.values()).collect(Collectors.toMap(TeleportOperatorType::getOid, Enum::name));
        }
    }
}

